/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;

public class PropertiesManager {
    public static void saveProperties(Properties properties, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            properties.store(outputStream, "Storing modified properties");
        }
    }

    public static Properties getProperties(URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            Properties properties = PropertiesManager.getProperties(reader);
            return properties;
        }
    }

    public static Properties getProperties(String fileName) throws IOException {
        return PropertiesManager.getProperties(new File(fileName));
    }

    public static Properties getProperties(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            Properties properties = PropertiesManager.getProperties(reader);
            return properties;
        }
    }

    private static Properties getProperties(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }
}

