/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.bonitasoft.engine.api.ImportError;
import org.bonitasoft.engine.profile.xml.ProfileEntryNode;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ParentProfileEntryNode
extends ProfileEntryNode {
    @XmlElementWrapper(name="childrenEntries")
    @XmlElement(name="profileEntry")
    private List<ProfileEntryNode> childProfileEntries = Collections.emptyList();

    public ParentProfileEntryNode() {
        this.childProfileEntries = new ArrayList<ProfileEntryNode>();
    }

    public List<ProfileEntryNode> getChildProfileEntries() {
        return this.childProfileEntries;
    }

    public void setChildProfileEntries(List<ProfileEntryNode> childProfileEntries) {
        this.childProfileEntries = childProfileEntries;
    }

    public ParentProfileEntryNode(String name) {
        super(name);
    }

    public List<ImportError> getErrors() {
        List<ProfileEntryNode> childProfileEntries;
        ArrayList<ImportError> errors = new ArrayList<ImportError>();
        if (this.hasError()) {
            errors.add(this.getError());
        }
        if ((childProfileEntries = this.getChildProfileEntries()) != null) {
            for (ProfileEntryNode childEntry : childProfileEntries) {
                if (!childEntry.hasError()) continue;
                errors.add(childEntry.getError());
            }
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors;
    }

    public boolean hasErrors() {
        return this.getErrors() != null;
    }

    @Override
    public ImportError getError() {
        if (this.getName() == null) {
            return new ImportError(this.getName(), ImportError.Type.PAGE);
        }
        return null;
    }

    public boolean hasCustomPages() {
        if (this.isCustom()) {
            return true;
        }
        if (this.getChildProfileEntries() != null) {
            for (ProfileEntryNode profileEntryNode : this.getChildProfileEntries()) {
                if (!profileEntryNode.isCustom()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParentProfileEntryNode that = (ParentProfileEntryNode)o;
        return Objects.equals(this.childProfileEntries, that.childProfileEntries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.childProfileEntries);
    }

    @Override
    public String toString() {
        return "ParentProfileEntryNode{" + super.toString() + "childProfileEntries=" + this.childProfileEntries + '}';
    }
}

