/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.impl;

import java.io.Serializable;
import org.bonitasoft.engine.exception.IncorrectParameterException;
import org.bonitasoft.engine.search.SearchFilterOperation;

public class SearchFilter
implements Serializable {
    private static final long serialVersionUID = 2476946810762051485L;
    private String field;
    private SearchFilterOperation operation;
    private Serializable value;
    private Serializable from;
    private Serializable to;

    public SearchFilter(String field, SearchFilterOperation operation, Serializable value) {
        this.field = field;
        this.operation = operation;
        this.value = value;
    }

    public SearchFilter(String field, Serializable from, Serializable to) {
        this.field = field;
        this.operation = SearchFilterOperation.BETWEEN;
        this.from = from;
        this.to = to;
    }

    public SearchFilter(SearchFilterOperation operation) throws IncorrectParameterException {
        this.operation = operation;
        if (!this.isUndefinedFieldNameAuthorized()) {
            throw new IncorrectParameterException("search operator can only be AND, OR, L_PARENTHESIS, R_PARENTHESIS on the one-parameter SearchFilter constructor");
        }
    }

    public boolean isUndefinedFieldNameAuthorized() {
        switch (this.operation) {
            case AND: 
            case OR: 
            case L_PARENTHESIS: 
            case R_PARENTHESIS: {
                return true;
            }
        }
        return false;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public SearchFilterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(SearchFilterOperation operation) {
        this.operation = operation;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public Serializable getFrom() {
        return this.from;
    }

    public Serializable getTo() {
        return this.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchFilter other = (SearchFilter)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

