/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.xml.parser;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public abstract class AbstractParser<T> {
    private final JAXBContext jaxbContext;

    public AbstractParser() {
        try {
            this.jaxbContext = this.initJAXBContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create an instance of class " + this.getClass().getName(), e);
        }
    }

    protected abstract JAXBContext initJAXBContext() throws JAXBException;

    protected abstract URL initSchemaURL();

    public T convert(String xml) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        URL schemaURL = this.initSchemaURL();
        try {
            unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL));
        }
        catch (SAXException e) {
            throw new JAXBException("Error while initializing schema from URL " + schemaURL, (Throwable)e);
        }
        return (T)unmarshaller.unmarshal((Reader)new StringReader(xml));
    }

    public String convert(T model) throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter writer = new StringWriter();
        marshaller.marshal(model, (Writer)writer);
        return writer.toString();
    }
}

