/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.api.ImportError;

public class ImportStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private Status status;
    private final List<ImportError> errors = new ArrayList<ImportError>();

    public ImportStatus(String name) {
        this.name = name;
        this.status = Status.ADDED;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<ImportError> getErrors() {
        return this.errors;
    }

    public void addError(ImportError error) {
        this.errors.add(error);
    }

    public void addErrors(List<ImportError> errors) {
        this.errors.addAll(errors);
    }

    public String toString() {
        return "ImportStatus [name=" + this.name + ", status=" + (Object)((Object)this.status) + ", errors=" + this.errors + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportStatus other = (ImportStatus)obj;
        if (this.errors == null ? other.errors != null : !this.errors.equals(other.errors)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.status == other.status;
    }

    public static enum Status {
        ADDED,
        REPLACED,
        SKIPPED;

    }
}

