/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.result;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.api.result.StatusContext;

public class Status
implements Serializable {
    private Level level;
    private String message;
    private StatusContext context;
    private StatusCode code;

    public static Status okStatus() {
        return new Status(Level.OK, StatusCode.OK, "", null);
    }

    public static Status errorStatus(StatusCode code, String message) {
        return Status.errorStatus(code, message, null);
    }

    public static Status errorStatus(StatusCode code, String message, Map<String, Serializable> context) {
        return new Status(Level.ERROR, code, message, context);
    }

    public static Status warningStatus(StatusCode code, String message) {
        return Status.warningStatus(code, message, null);
    }

    public static Status warningStatus(StatusCode code, String message, Map<String, Serializable> context) {
        return new Status(Level.WARNING, code, message, context);
    }

    public static Status infoStatus(StatusCode code, String message) {
        return Status.infoStatus(code, message, null);
    }

    public static Status infoStatus(StatusCode code, String message, Map<String, Serializable> context) {
        return new Status(Level.INFO, code, message, context);
    }

    private Status(Level level, StatusCode code, String message, Map<String, Serializable> context) {
        this.level = level;
        this.code = code;
        this.message = Objects.requireNonNull(message);
        this.context = context != null ? new StatusContext(context) : new StatusContext();
    }

    public StatusCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public StatusContext getContext() {
        return this.context;
    }

    public static enum Level {
        OK,
        ERROR,
        WARNING,
        INFO;

    }
}

