/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.bonitasoft.engine.bdm.model.QueryParameter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Query {
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    private String content;
    @XmlAttribute(required=true)
    private String returnType;
    @XmlElementWrapper(name="queryParameters")
    @XmlElement(name="queryParameter")
    private List<QueryParameter> queryParameters = new ArrayList<QueryParameter>();

    public Query() {
    }

    public Query(String name, String content, String returnType) {
        this();
        this.name = name;
        this.content = content;
        this.returnType = returnType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public QueryParameter addQueryParameter(String name, String className) {
        QueryParameter parameter = new QueryParameter(name, className);
        this.queryParameters.add(parameter);
        return parameter;
    }

    public List<QueryParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(List<QueryParameter> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean hasMultipleResults() {
        return List.class.getName().equals(this.returnType);
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.queryParameters == null ? 0 : this.queryParameters.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.queryParameters == null ? other.queryParameters != null : !this.queryParameters.equals(other.queryParameters)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    public String toString() {
        return "Query [name=" + this.name + ", content=" + this.content + ", returnType=" + this.returnType + ", queryParameters=" + this.queryParameters + "]";
    }
}

