/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class MultipleAggregationToItselfValidationRule
extends ValidationRule<BusinessObjectModel, ValidationStatus> {
    public MultipleAggregationToItselfValidationRule() {
        super(BusinessObjectModel.class);
    }

    @Override
    protected ValidationStatus validate(BusinessObjectModel bom) {
        ValidationStatus validationStatus = new ValidationStatus();
        for (BusinessObject bo : bom.getBusinessObjects()) {
            List<Field> boFields = bo.getFields();
            for (Field boField : boFields) {
                if (!(boField instanceof RelationField)) continue;
                RelationField relationField = (RelationField)boField;
                String fieldReferenceQualifiedName = relationField.getReference().getQualifiedName();
                String boQualifiedName = bo.getQualifiedName();
                if (relationField.getType() != RelationField.Type.AGGREGATION || !fieldReferenceQualifiedName.equals(boQualifiedName) || !relationField.isCollection().booleanValue()) continue;
                validationStatus.addError(StatusCode.MULTIPLE_AGGREGATION_RELATION_TO_ITSELF, "The object " + boQualifiedName + " is referencing itself in a multiple aggregation relation.", Collections.singletonMap("businessObjectName", boQualifiedName));
            }
        }
        return validationStatus;
    }
}

