/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.bonitasoft.engine.bpm.bar.ActorMappingContribution;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.bpm.bar.ClasspathContribution;
import org.bonitasoft.engine.bpm.bar.ConnectorContribution;
import org.bonitasoft.engine.bpm.bar.DocumentsResourcesContribution;
import org.bonitasoft.engine.bpm.bar.ExternalResourceContribution;
import org.bonitasoft.engine.bpm.bar.FormMappingContribution;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.bar.ParameterContribution;
import org.bonitasoft.engine.bpm.bar.ProcessDefinitionBARContribution;
import org.bonitasoft.engine.bpm.bar.UserFilterContribution;
import org.bonitasoft.engine.io.IOUtil;

public class BusinessArchiveFactory {
    private static final List<BusinessArchiveContribution> contributions = new ArrayList<BusinessArchiveContribution>();
    private static final BusinessArchiveFactory INSTANCE;

    public static BusinessArchive readBusinessArchive(InputStream inputStream) throws IOException, InvalidBusinessArchiveFormatException {
        Object barFolder = null;
        return INSTANCE.readBusinessArchive(inputStream, contributions);
    }

    public static BusinessArchive readBusinessArchive(File barOrFolder) throws InvalidBusinessArchiveFormatException, IOException {
        return INSTANCE.readBusinessArchive(barOrFolder, contributions);
    }

    public static void writeBusinessArchiveToFolder(BusinessArchive businessArchive, File folderPath) throws IOException {
        INSTANCE.writeBusinessArchiveToFolder(businessArchive, folderPath, contributions);
    }

    public static void writeBusinessArchiveToFile(BusinessArchive businessArchive, File businessArchiveFile) throws IOException {
        INSTANCE.writeBusinessArchiveToFile(businessArchive, businessArchiveFile, contributions);
    }

    public static String businessArchiveFolderToFile(File destFile, String folderPath) throws IOException {
        return INSTANCE.businessArchiveFolderToFile(destFile, folderPath, contributions);
    }

    protected BusinessArchive readBusinessArchive(InputStream inputStream, List<BusinessArchiveContribution> contributions) throws IOException, InvalidBusinessArchiveFormatException {
        File barFolder = File.createTempFile("tempBarFolder", null);
        barFolder.delete();
        barFolder.mkdir();
        try {
            IOUtil.unzipToFolder(inputStream, barFolder);
            BusinessArchive businessArchive = this.getBusinessArchive(barFolder, contributions);
            return businessArchive;
        }
        catch (InvalidBusinessArchiveFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidBusinessArchiveFormatException("Invalid format, can't read the BAR file", e);
        }
        finally {
            IOUtil.deleteDir(barFolder);
        }
    }

    protected BusinessArchive readBusinessArchive(File barOrFolder, List<BusinessArchiveContribution> contributions) throws InvalidBusinessArchiveFormatException, IOException {
        if (!barOrFolder.exists()) {
            throw new FileNotFoundException("the file does not exists: " + barOrFolder.getAbsolutePath());
        }
        if (barOrFolder.isDirectory()) {
            return this.getBusinessArchive(barOrFolder, contributions);
        }
        try (FileInputStream inputStream = new FileInputStream(barOrFolder);){
            BusinessArchive businessArchive = BusinessArchiveFactory.readBusinessArchive(inputStream);
            return businessArchive;
        }
    }

    private BusinessArchive getBusinessArchive(File barFolder, List<BusinessArchiveContribution> contributions) throws IOException, InvalidBusinessArchiveFormatException {
        BusinessArchive businessArchive = new BusinessArchive();
        for (BusinessArchiveContribution contribution : contributions) {
            if (contribution.readFromBarFolder(businessArchive, barFolder) || !contribution.isMandatory()) continue;
            throw new InvalidBusinessArchiveFormatException("Invalid format, can't read '" + contribution.getName() + "' from the BAR file");
        }
        return businessArchive;
    }

    protected void writeBusinessArchiveToFolder(BusinessArchive businessArchive, File folderPath, List<BusinessArchiveContribution> contributions) throws IOException {
        if (folderPath.exists()) {
            if (!folderPath.isDirectory()) {
                throw new IOException("unable to create Business archive on a file " + folderPath);
            }
        } else {
            folderPath.mkdirs();
        }
        for (BusinessArchiveContribution contribution : contributions) {
            contribution.saveToBarFolder(businessArchive, folderPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBusinessArchiveToFile(BusinessArchive businessArchive, File businessArchiveFile, List<BusinessArchiveContribution> contributions) throws IOException {
        File tempFile = File.createTempFile("tempBarFolder", null);
        tempFile.delete();
        tempFile.mkdir();
        try {
            BusinessArchiveFactory.writeBusinessArchiveToFolder(businessArchive, tempFile);
            this.zipBarFolder(businessArchiveFile, tempFile);
        }
        finally {
            IOUtil.deleteDir(tempFile);
        }
    }

    protected String businessArchiveFolderToFile(File destFile, String folderPath, List<BusinessArchiveContribution> contributions) throws IOException {
        this.zipBarFolder(destFile, new File(folderPath));
        return destFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipBarFolder(File businessArchiveFile, File folder) throws IOException {
        if (businessArchiveFile.exists()) {
            throw new IOException("The destination file already exists " + businessArchiveFile.getAbsolutePath());
        }
        try (FileOutputStream fileOutput = new FileOutputStream(businessArchiveFile);
             ZipOutputStream zos = new ZipOutputStream(fileOutput);){
            IOUtil.zipDir(folder.getAbsolutePath(), zos, folder.getAbsolutePath());
        }
    }

    static {
        contributions.add(new ProcessDefinitionBARContribution());
        contributions.add(new ParameterContribution());
        contributions.add(new ConnectorContribution());
        contributions.add(new ExternalResourceContribution());
        contributions.add(new ActorMappingContribution());
        contributions.add(new UserFilterContribution());
        contributions.add(new DocumentsResourcesContribution());
        contributions.add(new ClasspathContribution());
        contributions.add(new FormMappingContribution());
        INSTANCE = new BusinessArchiveFactory();
    }
}

