/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.TransitionDefinitionImpl;
import org.bonitasoft.engine.bpm.internal.NamedDefinitionElementImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.impl.ExpressionImpl;

@XmlTransient
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class FlowNodeDefinitionImpl
extends NamedDefinitionElementImpl
implements FlowNodeDefinition {
    private static final long serialVersionUID = 429640943678358154L;
    @XmlIDREF
    @XmlElement(type=TransitionDefinitionImpl.class, name="incomingTransition")
    private final List<TransitionDefinition> incomings = new ArrayList<TransitionDefinition>();
    @XmlIDREF
    @XmlElement(type=TransitionDefinitionImpl.class, name="outgoingTransition")
    private final List<TransitionDefinition> outgoings = new ArrayList<TransitionDefinition>();
    @XmlElement(type=ConnectorDefinitionImpl.class, name="connector")
    private final List<ConnectorDefinition> connectors = new ArrayList<ConnectorDefinition>();
    @XmlElement
    private String description;
    @XmlElement(type=ExpressionImpl.class)
    private Expression displayDescription;
    @XmlElement(type=ExpressionImpl.class)
    private Expression displayName;
    @XmlElement(type=ExpressionImpl.class)
    private Expression displayDescriptionAfterCompletion;
    @XmlIDREF
    @XmlElement(type=TransitionDefinitionImpl.class)
    private TransitionDefinition defaultTransition;

    public FlowNodeDefinitionImpl(long id, String name) {
        super(name);
        this.setId(id);
    }

    public FlowNodeDefinitionImpl(String name) {
        super(name);
    }

    public FlowNodeDefinitionImpl() {
    }

    @Override
    public TransitionDefinition getDefaultTransition() {
        return this.defaultTransition;
    }

    public void setDefaultTransition(TransitionDefinition defaultTransition) {
        this.defaultTransition = defaultTransition;
    }

    @Override
    public List<TransitionDefinition> getOutgoingTransitions() {
        return Collections.unmodifiableList(this.outgoings);
    }

    @Override
    public List<TransitionDefinition> getIncomingTransitions() {
        return Collections.unmodifiableList(this.incomings);
    }

    @Override
    public List<ConnectorDefinition> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public void addIncomingTransition(TransitionDefinition transition) {
        if (!this.incomings.contains(transition)) {
            this.incomings.add(transition);
        }
    }

    public void addIncomingTransition(int index, TransitionDefinition transition) {
        if (!this.incomings.contains(transition)) {
            this.incomings.add(index, transition);
        }
    }

    public void removeIncomingTransition(TransitionDefinition transition) {
        this.incomings.remove(transition);
    }

    public void addOutgoingTransition(TransitionDefinition transition) {
        if (!this.outgoings.contains(transition)) {
            this.outgoings.add(transition);
        }
    }

    public void addOutgoingTransition(int index, TransitionDefinition transition) {
        if (!this.outgoings.contains(transition)) {
            this.outgoings.add(index, transition);
        }
    }

    public void removeOutgoingTransition(TransitionDefinition transition) {
        this.outgoings.remove(transition);
    }

    @Override
    public void addConnector(ConnectorDefinition connectorDefinition) {
        this.connectors.add(connectorDefinition);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayDescription(Expression displayDescription) {
        this.displayDescription = ExpressionBuilder.getNonNullCopy(displayDescription);
    }

    public void setDisplayName(Expression displayName) {
        this.displayName = ExpressionBuilder.getNonNullCopy(displayName);
    }

    public void setDisplayDescriptionAfterCompletion(Expression displayDescriptionAfterCompletion) {
        this.displayDescriptionAfterCompletion = ExpressionBuilder.getNonNullCopy(displayDescriptionAfterCompletion);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Expression getDisplayDescription() {
        return this.displayDescription;
    }

    @Override
    public Expression getDisplayName() {
        return this.displayName;
    }

    @Override
    public Expression getDisplayDescriptionAfterCompletion() {
        return this.displayDescriptionAfterCompletion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlowNodeDefinitionImpl that = (FlowNodeDefinitionImpl)o;
        return Objects.equals(this.incomings, that.incomings) && Objects.equals(this.outgoings, that.outgoings) && Objects.equals(this.connectors, that.connectors) && Objects.equals(this.description, that.description) && Objects.equals(this.displayDescription, that.displayDescription) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.displayDescriptionAfterCompletion, that.displayDescriptionAfterCompletion) && Objects.equals(this.defaultTransition, that.defaultTransition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.incomings, this.outgoings, this.connectors, this.description, this.displayDescription, this.displayName, this.displayDescriptionAfterCompletion, this.defaultTransition);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("incomings", this.incomings).append("outgoings", this.outgoings).append("connectors", this.connectors).append("description", (Object)this.description).append("displayDescription", (Object)this.displayDescription).append("displayName", (Object)this.displayName).append("displayDescriptionAfterCompletion", (Object)this.displayDescriptionAfterCompletion).append("defaultTransition", (Object)this.defaultTransition).toString();
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }
}

