/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.client.invoker.ApiClient;
import org.bonitasoft.web.client.invoker.EncodingUtils;
import org.bonitasoft.web.client.model.Application;
import org.bonitasoft.web.client.model.ApplicationUpdateRequest;
import org.bonitasoft.web.client.model.CreateApplicationRequest;

public interface ApplicationApi
extends ApiClient.Api {
    @RequestLine(value="POST /API/living/application")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Application createApplication(CreateApplicationRequest var1);

    @RequestLine(value="DELETE /API/living/application/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteApplicationById(@Param(value="id") String var1);

    @RequestLine(value="GET /API/living/application/{id}")
    @Headers(value={"Accept: application/json"})
    public Application getApplicationById(@Param(value="id") String var1);

    @RequestLine(value="POST /services/application/import")
    @Headers(value={"Content-Type: application/x-www-form-urlencoded", "Accept: application/json"})
    public void importApplication(@Param(value="applicationsDataUpload") String var1, @Param(value="importPolicy") String var2);

    @RequestLine(value="GET /API/living/application?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<Application> searchApplications(@Param(value="p") Integer var1, @Param(value="c") Integer var2, @Param(value="f") List<String> var3, @Param(value="o") String var4, @Param(value="s") String var5);

    @RequestLine(value="GET /API/living/application?p={p}&c={c}&f={f}&o={o}&s={s}")
    @Headers(value={"Accept: application/json"})
    public List<Application> searchApplications(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PUT /API/living/application/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Application updateApplicationById(@Param(value="id") String var1, ApplicationUpdateRequest var2);

    @RequestLine(value="POST /portal/applicationsUpload")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public String uploadApplication(@Param(value="file") File var1);

    @RequestLine(value="POST /APIv2/service/install")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public String uploadApplicationConfiguration(@Param(value="configuration") File var1);

    public static class SearchApplicationsQueryParams
    extends HashMap<String, Object> {
        public SearchApplicationsQueryParams p(Integer value) {
            this.put("p", EncodingUtils.encode(value));
            return this;
        }

        public SearchApplicationsQueryParams c(Integer value) {
            this.put("c", EncodingUtils.encode(value));
            return this;
        }

        public SearchApplicationsQueryParams f(List<String> value) {
            this.put("f", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchApplicationsQueryParams o(String value) {
            this.put("o", EncodingUtils.encode(value));
            return this;
        }

        public SearchApplicationsQueryParams s(String value) {
            this.put("s", EncodingUtils.encode(value));
            return this;
        }
    }
}

