/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.webcamcapture;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.StandardAlgConfigPanel;
import com.github.sarxos.webcam.Webcam;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class OpenWebcamDialog
extends StandardAlgConfigPanel {
    JDialog dialog;
    JComboBox comboCameras;
    Webcam selectedCamera;
    JFormattedTextField fieldWidth;
    JFormattedTextField fieldHeight;
    int width;
    int height;
    DefaultComboBoxModel modelSizes = new DefaultComboBoxModel();
    JComboBox comboSizes = new JComboBox(this.modelSizes);
    JCheckBox cSave = new JCheckBox("Save");
    JButton bCancel = new JButton("Cancel");
    JButton bOK = new JButton("OK");
    volatile boolean concluded = false;
    ActionListener cameraListener;
    ActionListener sizeListener;

    public OpenWebcamDialog(JDialog dialog) {
        this.dialog = dialog;
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        final List cameras = Webcam.getWebcams();
        Vector<String> names = new Vector<String>();
        for (Webcam w : cameras) {
            names.add(w.getName());
        }
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenWebcamDialog.this.actionOK();
            }
        });
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenWebcamDialog.this.actionCancel();
            }
        });
        this.cSave.setSelected(true);
        this.fieldWidth = BoofSwingUtil.createTextField((int)0, (int)0, (int)20000);
        this.fieldHeight = BoofSwingUtil.createTextField((int)0, (int)0, (int)20000);
        this.fieldWidth.setPreferredSize(new Dimension(150, 30));
        this.fieldHeight.setPreferredSize(new Dimension(150, 30));
        this.fieldWidth.setMaximumSize(this.fieldWidth.getPreferredSize());
        this.fieldHeight.setMaximumSize(this.fieldHeight.getPreferredSize());
        this.fieldWidth.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OpenWebcamDialog.this.width = (Integer)OpenWebcamDialog.this.fieldWidth.getValue();
            }
        });
        this.fieldHeight.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OpenWebcamDialog.this.height = (Integer)OpenWebcamDialog.this.fieldHeight.getValue();
            }
        });
        this.comboSizes.setPreferredSize(new Dimension(200, 30));
        this.comboSizes.setMaximumSize(this.comboSizes.getPreferredSize());
        this.comboCameras = new JComboBox(names);
        this.comboCameras.setPreferredSize(new Dimension(200, 30));
        this.comboCameras.setMaximumSize(this.comboCameras.getPreferredSize());
        this.cameraListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Webcam w;
                OpenWebcamDialog.this.selectedCamera = w = (Webcam)cameras.get(OpenWebcamDialog.this.comboCameras.getSelectedIndex());
                Dimension s = w.getViewSize();
                OpenWebcamDialog.this.setCameraSize(s.width, s.height);
                OpenWebcamDialog.this.comboSizes.removeActionListener(OpenWebcamDialog.this.sizeListener);
                OpenWebcamDialog.this.modelSizes.removeAllElements();
                for (Dimension d : w.getViewSizes()) {
                    OpenWebcamDialog.this.modelSizes.addElement(d.width + " x " + d.height);
                }
                OpenWebcamDialog.this.comboSizes.addActionListener(OpenWebcamDialog.this.sizeListener);
            }
        };
        this.comboCameras.addActionListener(this.cameraListener);
        this.sizeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Webcam w;
                OpenWebcamDialog.this.selectedCamera = w = (Webcam)cameras.get(OpenWebcamDialog.this.comboCameras.getSelectedIndex());
                String text = (String)OpenWebcamDialog.this.comboSizes.getSelectedItem();
                if (text == null) {
                    return;
                }
                String[] words = text.split(" x ");
                int width = Integer.parseInt(words[0]);
                int height = Integer.parseInt(words[1]);
                OpenWebcamDialog.this.setCameraSize(width, height);
            }
        };
        this.comboSizes.addActionListener(this.sizeListener);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 0));
        sizePanel.add(this.fieldWidth);
        sizePanel.add(Box.createHorizontalStrut(10));
        sizePanel.add(this.fieldHeight);
        sizePanel.setMaximumSize(sizePanel.getPreferredSize());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.bCancel);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.bOK);
        dialog.getRootPane().setDefaultButton(this.bOK);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new BoxLayout(checkPanel, 0));
        checkPanel.add(this.cSave);
        checkPanel.add(Box.createHorizontalGlue());
        OpenWebcamDialog.addLabeled((JComponent)this.comboCameras, (String)"Webcam", (JPanel)((Object)this));
        OpenWebcamDialog.addLabeled((JComponent)sizePanel, (String)"Size", (JPanel)((Object)this));
        OpenWebcamDialog.addAlignRight((JComponent)this.comboSizes, (JPanel)((Object)this));
        this.add(checkPanel);
        this.add(buttonPanel);
        this.comboCameras.setSelectedIndex(0);
        this.loadPreferences();
    }

    public boolean loadPreferences() {
        Preferences prefs = Preferences.userRoot().node(((Object)((Object)this)).getClass().getSimpleName());
        String cameraName = prefs.get("camera", "");
        int width = prefs.getInt("width", -1);
        int height = prefs.getInt("height", -1);
        if (cameraName.length() <= 0) {
            return false;
        }
        List cameras = Webcam.getWebcams();
        int match = -1;
        for (int i = 0; i < cameras.size(); ++i) {
            Webcam w = (Webcam)cameras.get(i);
            if (!w.getName().equals(cameraName)) continue;
            match = i;
            break;
        }
        if (match == -1) {
            return false;
        }
        this.comboCameras.removeActionListener(this.cameraListener);
        this.comboCameras.setSelectedIndex(match);
        if (width > 0 && height > 0) {
            this.setCameraSize(width, height);
        }
        this.comboCameras.addActionListener(this.cameraListener);
        return true;
    }

    public void savePreferences() {
        if (this.selectedCamera == null) {
            return;
        }
        Preferences prefs = Preferences.userRoot().node(((Object)((Object)this)).getClass().getSimpleName());
        prefs.put("camera", this.selectedCamera.getName());
        prefs.putInt("width", this.width);
        prefs.putInt("height", this.height);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void setCameraSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.fieldWidth.setValue(width);
        this.fieldHeight.setValue(height);
    }

    public static Selection showDialog(Window owner) {
        JDialog dialog = new JDialog(owner, "Select Webcam", Dialog.ModalityType.APPLICATION_MODAL);
        final OpenWebcamDialog panel = new OpenWebcamDialog(dialog);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                panel.actionCancel();
            }
        });
        dialog.setDefaultCloseOperation(0);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)((Object)panel), "Center");
        dialog.setSize(new Dimension(400, 200));
        if (owner != null) {
            dialog.setLocationRelativeTo(owner);
        }
        dialog.setVisible(true);
        dialog.dispose();
        if (panel.selectedCamera != null) {
            Selection s = new Selection();
            s.camera = panel.selectedCamera;
            s.width = panel.getSelectedWidth();
            s.height = panel.getSelectedHeight();
            return s;
        }
        return null;
    }

    public void actionOK() {
        if (this.cSave.isSelected()) {
            this.savePreferences();
        }
        this.dialog.setVisible(false);
        this.concluded = true;
    }

    public void actionCancel() {
        this.selectedCamera = null;
        this.dialog.setVisible(false);
        this.concluded = true;
    }

    public Webcam getSelectedCamera() {
        return this.selectedCamera;
    }

    public int getSelectedWidth() {
        return this.width;
    }

    public int getSelectedHeight() {
        return this.height;
    }

    public static void main(String[] args) {
        Selection s = OpenWebcamDialog.showDialog(null);
        if (s != null) {
            System.out.println("Selected camera. " + s.width + " " + s.height);
        } else {
            System.out.println("Didn't select camera");
        }
        System.exit(0);
    }

    public static class Selection {
        public Webcam camera;
        public int width;
        public int height;
    }
}

