/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.webcamcapture;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.webcamcapture.UtilWebcamCapture;
import boofcv.io.wrapper.WebcamInterface;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import com.github.sarxos.webcam.Webcam;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class WebcamCaptureWebcamInterface
implements WebcamInterface {
    public <T extends ImageBase<T>> SimpleImageSequence<T> open(String device, int width, int height, ImageType<T> imageType) {
        if (device != null) {
            Webcam webcam;
            try {
                int which = Integer.parseInt(device);
                webcam = (Webcam)Webcam.getWebcams().get(which);
            }
            catch (NumberFormatException ignore) {
                webcam = UtilWebcamCapture.findDevice(device);
            }
            if (webcam == null) {
                throw new RuntimeException("Can't find webcam with ID or name at " + device);
            }
            try {
                if (width >= 0 && height >= 0) {
                    UtilWebcamCapture.adjustResolution(webcam, width, height);
                }
                webcam.open();
                return new SimpleSequence<T>(webcam, imageType);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return new SimpleSequence<T>(device, width, height, imageType);
    }

    public static class SimpleSequence<T extends ImageBase<T>>
    implements SimpleImageSequence<T> {
        Webcam webcam;
        int width;
        int height;
        T output;
        BufferedImage bufferedImage;
        int frames = 0;

        public SimpleSequence(String device, int width, int height, ImageType<T> imageType) {
            this(UtilWebcamCapture.openDefault(width, height), imageType);
        }

        public SimpleSequence(Webcam webcam, ImageType<T> imageType) {
            this.webcam = webcam;
            Dimension d = webcam.getDevice().getResolution();
            this.width = d.width;
            this.height = d.height;
            this.output = imageType.createImage(this.width, this.height);
        }

        public int getNextWidth() {
            return this.width;
        }

        public int getNextHeight() {
            return this.height;
        }

        public boolean hasNext() {
            this.bufferedImage = this.webcam.getImage();
            return this.bufferedImage != null;
        }

        public T next() {
            if (this.bufferedImage == null) {
                this.bufferedImage = this.webcam.getImage();
            }
            ConvertBufferedImage.convertFrom((BufferedImage)this.bufferedImage, this.output, (boolean)true);
            return this.output;
        }

        public void close() {
            this.webcam.close();
        }

        public int getFrameNumber() {
            return this.frames;
        }

        public void setLoop(boolean loop) {
        }

        public ImageType<T> getImageType() {
            return this.output.getImageType();
        }

        public void reset() {
            throw new RuntimeException("Not supported");
        }

        public BufferedImage getGuiImage() {
            return this.bufferedImage;
        }
    }
}

