/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android.gui;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import boofcv.android.ConvertBitmap;
import boofcv.android.gui.VideoRenderProcessing;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public abstract class VideoImageProcessing<T extends ImageBase<T>>
extends VideoRenderProcessing<T> {
    private Bitmap output;
    private Bitmap outputGUI;
    private byte[] storage;

    protected VideoImageProcessing(ImageType<T> imageType) {
        super(imageType);
    }

    @Override
    protected void declareImages(int width, int height) {
        super.declareImages(width, height);
        this.output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.outputGUI = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.storage = ConvertBitmap.declareStorage(this.output, this.storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(T gray) {
        this.process(gray, this.output, this.storage);
        Object object = this.lockGui;
        synchronized (object) {
            Bitmap tmp = this.output;
            this.output = this.outputGUI;
            this.outputGUI = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render(Canvas canvas, double imageToOutput) {
        Object object = this.lockGui;
        synchronized (object) {
            canvas.drawBitmap(this.outputGUI, 0.0f, 0.0f, null);
        }
    }

    protected abstract void process(T var1, Bitmap var2, byte[] var3);
}

