/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.RadialDistortionEstimateLinear;
import boofcv.alg.geo.calibration.Zhang99AllParam;
import boofcv.alg.geo.calibration.Zhang99CalibrationMatrixFromHomographies;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import boofcv.alg.geo.calibration.Zhang99DecomposeHomography;
import boofcv.alg.geo.calibration.Zhang99IntrinsicParam;
import boofcv.alg.geo.calibration.Zhang99OptimizationFunction;
import boofcv.alg.geo.calibration.Zhang99OptimizationJacobian;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrixRMaj;

public class CalibrationPlanarGridZhang99 {
    private Zhang99ComputeTargetHomography computeHomography;
    private Zhang99CalibrationMatrixFromHomographies computeK;
    private RadialDistortionEstimateLinear computeRadial;
    private Zhang99DecomposeHomography decomposeH = new Zhang99DecomposeHomography();
    private Zhang99AllParam initial;
    private Zhang99AllParam optimized;
    private UnconstrainedLeastSquares optimizer;
    private Listener listener;
    private List<Point2D_F64> layout;

    public CalibrationPlanarGridZhang99(List<Point2D_F64> layout, Zhang99IntrinsicParam intrinsicParam) {
        this.layout = layout;
        this.computeHomography = new Zhang99ComputeTargetHomography(layout);
        this.computeK = new Zhang99CalibrationMatrixFromHomographies(intrinsicParam.assumeZeroSkew);
        this.computeRadial = new RadialDistortionEstimateLinear(layout, intrinsicParam.getNumberOfRadial());
        this.optimized = new Zhang99AllParam(intrinsicParam, 0);
        this.initial = this.optimized.createLike();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean process(List<CalibrationObservation> observations) {
        if (!this.linearEstimate(observations, this.initial)) {
            return false;
        }
        this.status("Non-linear refinement");
        this.optimized.setNumberOfViews(observations.size());
        return this.optimizedParam(observations, this.layout, this.initial, this.optimized, this.optimizer);
    }

    protected boolean linearEstimate(List<CalibrationObservation> observations, Zhang99AllParam param) {
        this.status("Estimating Homographies");
        ArrayList<DMatrixRMaj> homographies = new ArrayList<DMatrixRMaj>();
        ArrayList<Se3_F64> motions = new ArrayList<Se3_F64>();
        for (CalibrationObservation calibrationObservation : observations) {
            if (!this.computeHomography.computeHomography(calibrationObservation)) {
                return false;
            }
            DMatrixRMaj H = this.computeHomography.getHomography();
            homographies.add(H);
        }
        this.status("Estimating Calibration Matrix");
        this.computeK.process(homographies);
        DMatrixRMaj K = this.computeK.getCalibrationMatrix();
        this.decomposeH.setCalibrationMatrix(K);
        for (DMatrixRMaj H : homographies) {
            motions.add(this.decomposeH.decompose(H));
        }
        this.status("Estimating Radial Distortion");
        this.computeRadial.process(K, homographies, observations);
        double[] dArray = this.computeRadial.getParameters();
        this.convertIntoZhangParam(motions, K, dArray, param);
        return true;
    }

    private void status(String message) {
        if (this.listener != null && !this.listener.zhangUpdate(message)) {
            throw new RuntimeException("User requested termination of calibration");
        }
    }

    public boolean optimizedParam(List<CalibrationObservation> observations, List<Point2D_F64> grid, Zhang99AllParam initial, Zhang99AllParam found, UnconstrainedLeastSquares optimizer) {
        if (optimizer == null) {
            optimizer = FactoryOptimization.leastSquaresLM((double)0.001, (boolean)true);
        }
        double[] model = new double[initial.numParameters()];
        initial.convertToParam(model);
        Zhang99OptimizationFunction func = new Zhang99OptimizationFunction(initial.createLike(), grid, observations);
        Zhang99OptimizationJacobian jacobian = initial.getIntrinsic().createJacobian(observations, grid);
        optimizer.setFunction((FunctionNtoM)func, (FunctionNtoMxN)jacobian);
        optimizer.initialize(model, 1.0E-10, 1.0E-25 * (double)observations.size());
        for (int i = 0; i < 500 && !optimizer.iterate(); ++i) {
            if (i % 25 != 0) continue;
            this.status("Progress " + (double)(100 * i) / 500.0 + "%");
        }
        double[] param = optimizer.getParameters();
        found.setFromParam(param);
        return true;
    }

    public void convertIntoZhangParam(List<Se3_F64> motions, DMatrixRMaj K, double[] distort, Zhang99AllParam param) {
        param.getIntrinsic().initialize(K, distort);
        param.setNumberOfViews(motions.size());
        for (int i = 0; i < param.views.length; ++i) {
            Se3_F64 m = motions.get(i);
            Zhang99AllParam.View v = new Zhang99AllParam.View();
            v.T = m.getT();
            ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)m.getR(), (Rodrigues_F64)v.rotation);
            param.views[i] = v;
        }
    }

    public static void applyDistortion(Point2D_F64 normPt, double[] radial, double t1, double t2) {
        double r2;
        double x = normPt.x;
        double y = normPt.y;
        double a = 0.0;
        double r2i = r2 = x * x + y * y;
        for (int i = 0; i < radial.length; ++i) {
            a += radial[i] * r2i;
            r2i *= r2;
        }
        normPt.x = x + x * a + 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
        normPt.y = y + y * a + t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
    }

    public void setOptimizer(UnconstrainedLeastSquares optimizer) {
        this.optimizer = optimizer;
    }

    public Zhang99AllParam getOptimized() {
        return this.optimized;
    }

    public static int totalPoints(List<CalibrationObservation> observations) {
        int total = 0;
        for (int i = 0; i < observations.size(); ++i) {
            total += observations.get(i).size();
        }
        return total;
    }

    public static interface Listener {
        public boolean zhangUpdate(String var1);
    }
}

