/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.Zhang99IntrinsicParam;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.so.Rodrigues_F64;

public class Zhang99AllParam {
    public View[] views;
    Zhang99IntrinsicParam intrinsic;

    public Zhang99AllParam(Zhang99IntrinsicParam intrinsic, int numViews) {
        this.intrinsic = intrinsic;
        this.setNumberOfViews(numViews);
    }

    public void setNumberOfViews(int numViews) {
        this.views = new View[numViews];
        for (int i = 0; i < numViews; ++i) {
            this.views[i] = new View();
        }
    }

    public Zhang99AllParam createLike() {
        return new Zhang99AllParam(this.intrinsic.createLike(), this.views.length);
    }

    public Zhang99AllParam copy() {
        Zhang99AllParam ret = this.createLike();
        ret.intrinsic.setTo(this.intrinsic);
        for (int i = 0; i < this.views.length; ++i) {
            View a = this.views[i];
            View b = ret.views[i];
            b.rotation.unitAxisRotation.set(a.rotation.unitAxisRotation);
            b.rotation.theta = a.rotation.theta;
            b.T.set(a.T);
        }
        return ret;
    }

    public int numParameters() {
        return this.intrinsic.numParameters() + 6 * this.views.length;
    }

    public int setFromParam(double[] param) {
        int index = this.intrinsic.setFromParam(param);
        for (View v : this.views) {
            v.rotation.setParamVector(param[index++], param[index++], param[index++]);
            v.T.x = param[index++];
            v.T.y = param[index++];
            v.T.z = param[index++];
        }
        return index;
    }

    public int convertToParam(double[] param) {
        int index = this.intrinsic.convertToParam(param);
        for (View v : this.views) {
            param[index++] = v.rotation.unitAxisRotation.x * v.rotation.theta;
            param[index++] = v.rotation.unitAxisRotation.y * v.rotation.theta;
            param[index++] = v.rotation.unitAxisRotation.z * v.rotation.theta;
            param[index++] = v.T.x;
            param[index++] = v.T.y;
            param[index++] = v.T.z;
        }
        return index;
    }

    public Zhang99IntrinsicParam getIntrinsic() {
        return this.intrinsic;
    }

    public static class View {
        public Rodrigues_F64 rotation = new Rodrigues_F64();
        public Vector3D_F64 T = new Vector3D_F64();
    }
}

