/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.RodriguesRotationJacobian;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.pinhole.CalibParamPinholeRadial;
import boofcv.struct.calib.CameraPinholeRadial;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DMatrixRMaj;

public class Zhang99OptimizationJacobian
implements FunctionNtoMxN<DMatrixRMaj> {
    RodriguesRotationJacobian rodJacobian = new RodriguesRotationJacobian();
    Rodrigues_F64 rodrigues = new Rodrigues_F64();
    private int numParam;
    private int numFuncs;
    private List<Point3D_F64> grid = new ArrayList<Point3D_F64>();
    private List<CalibrationObservation> observationSets;
    private Se3_F64 se = new Se3_F64();
    private Point3D_F64 cameraPt = new Point3D_F64();
    private Point2D_F64 normPt = new Point2D_F64();
    private Point2D_F64 dnormPt = new Point2D_F64();
    private CalibParamPinholeRadial param;
    private CameraPinholeRadial intrinsic;
    int indexJacX;
    int indexJacY;
    Point3D_F64 Xdot = new Point3D_F64();

    public Zhang99OptimizationJacobian(CalibParamPinholeRadial param, List<CalibrationObservation> observationSets, List<Point2D_F64> grid) {
        this.param = param;
        this.observationSets = observationSets;
        for (Point2D_F64 p : grid) {
            this.grid.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        this.numParam = param.numParameters() + 6 * observationSets.size();
        this.numFuncs = CalibrationPlanarGridZhang99.totalPoints(observationSets) * 2;
    }

    public int getNumOfInputsN() {
        return this.numParam;
    }

    public int getNumOfOutputsM() {
        return this.numFuncs;
    }

    public void process(double[] input, DMatrixRMaj J) {
        double[] output = J.data;
        int index = this.param.setFromParam(input);
        this.intrinsic = this.param.getCameraModel();
        int indexPoint = 0;
        for (int indexView = 0; indexView < this.observationSets.size(); ++indexView) {
            CalibrationObservation set = this.observationSets.get(indexView);
            double rodX = input[index++];
            double rodY = input[index++];
            double rodZ = input[index++];
            double tranX = input[index++];
            double tranY = input[index++];
            double tranZ = input[index++];
            this.rodrigues.setParamVector(rodX, rodY, rodZ);
            this.rodJacobian.process(rodX, rodY, rodZ);
            ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)this.rodrigues, (DMatrixRMaj)this.se.getR());
            this.se.T.set(tranX, tranY, tranZ);
            int i = 0;
            while (i < set.size()) {
                int gridIndex = set.points.get((int)i).index;
                this.indexJacX = 2 * indexPoint * this.numParam;
                this.indexJacY = (2 * indexPoint + 1) * this.numParam;
                SePointOps_F64.transform((Se3_F64)this.se, (Point3D_F64)this.grid.get(gridIndex), (Point3D_F64)this.cameraPt);
                this.normPt.x = this.cameraPt.x / this.cameraPt.z;
                this.normPt.y = this.cameraPt.y / this.cameraPt.z;
                this.dnormPt.set(this.normPt);
                CalibrationPlanarGridZhang99.applyDistortion(this.dnormPt, this.intrinsic.radial, this.intrinsic.t1, this.intrinsic.t2);
                this.calibrationGradient(this.dnormPt, output);
                this.distortGradient(this.normPt, output);
                this.indexJacX += indexView * 6;
                this.indexJacY += indexView * 6;
                this.rodriguesGradient(this.rodJacobian.Rx, this.grid.get(gridIndex), this.cameraPt, this.normPt, output);
                this.rodriguesGradient(this.rodJacobian.Ry, this.grid.get(gridIndex), this.cameraPt, this.normPt, output);
                this.rodriguesGradient(this.rodJacobian.Rz, this.grid.get(gridIndex), this.cameraPt, this.normPt, output);
                this.translateGradient(this.cameraPt, this.normPt, output);
                ++i;
                ++indexPoint;
            }
        }
    }

    public DMatrixRMaj declareMatrixMxN() {
        return new DMatrixRMaj(this.getNumOfOutputsM(), this.getNumOfInputsN());
    }

    private void calibrationGradient(Point2D_F64 distNorm, double[] output) {
        output[this.indexJacX++] = distNorm.x;
        output[this.indexJacX++] = 0.0;
        if (!this.param.assumeZeroSkew) {
            output[this.indexJacX++] = distNorm.y;
        }
        output[this.indexJacX++] = 1.0;
        output[this.indexJacX++] = 0.0;
        output[this.indexJacY++] = 0.0;
        output[this.indexJacY++] = distNorm.y;
        if (!this.param.assumeZeroSkew) {
            output[this.indexJacY++] = 0.0;
        }
        output[this.indexJacY++] = 0.0;
        output[this.indexJacY++] = 1.0;
    }

    private void distortGradient(Point2D_F64 norm, double[] output) {
        double r2;
        double r2i = r2 = norm.x * norm.x + norm.y * norm.y;
        for (int i = 0; i < this.intrinsic.radial.length; ++i) {
            double xdot = norm.x * r2i;
            double ydot = norm.y * r2i;
            output[this.indexJacX++] = this.intrinsic.fx * xdot + this.intrinsic.skew * ydot;
            output[this.indexJacY++] = this.intrinsic.fy * ydot;
            r2i *= r2;
        }
        if (this.param.includeTangential) {
            double xy2 = 2.0 * norm.x * norm.y;
            double r2yy = r2 + 2.0 * norm.y * norm.y;
            double r2xx = r2 + 2.0 * norm.x * norm.x;
            output[this.indexJacX++] = this.intrinsic.fx * xy2 + this.intrinsic.skew * r2yy;
            output[this.indexJacY++] = this.intrinsic.fy * r2yy;
            output[this.indexJacX++] = this.intrinsic.fx * r2xx + this.intrinsic.skew * xy2;
            output[this.indexJacY++] = this.intrinsic.fy * xy2;
        }
    }

    private void rodriguesGradient(DMatrixRMaj Rdot, Point3D_F64 X, Point3D_F64 cameraPt, Point2D_F64 normPt, double[] output) {
        double r2;
        double x = normPt.x;
        double y = normPt.y;
        double r2i = r2 = x * x + y * y;
        double rdev = 1.0;
        double sum = 0.0;
        double sumdot = 0.0;
        for (int i = 0; i < this.intrinsic.radial.length; ++i) {
            sum += this.intrinsic.radial[i] * r2i;
            sumdot += this.intrinsic.radial[i] * 2.0 * (double)(i + 1) * rdev;
            r2i *= r2;
            rdev *= r2;
        }
        GeometryMath_F64.mult((DMatrixRMaj)Rdot, (GeoTuple3D_F64)X, (GeoTuple3D_F64)this.Xdot);
        double r_dot = (x * this.Xdot.x + y * this.Xdot.y) / cameraPt.z - r2 * this.Xdot.z / cameraPt.z;
        double n_dot_x = (-x * this.Xdot.z + this.Xdot.x) / cameraPt.z;
        double n_dot_y = (-y * this.Xdot.z + this.Xdot.y) / cameraPt.z;
        double xdot = sumdot * r_dot * x + (1.0 + sum) * n_dot_x;
        double ydot = sumdot * r_dot * y + (1.0 + sum) * n_dot_y;
        if (this.param.includeTangential) {
            xdot += 2.0 * this.intrinsic.t1 * (n_dot_x * y + x * n_dot_y) + 6.0 * this.intrinsic.t2 * x * n_dot_x + 2.0 * this.intrinsic.t2 * y * n_dot_y;
            ydot += 2.0 * this.intrinsic.t1 * x * n_dot_x + 6.0 * this.intrinsic.t1 * y * n_dot_y + 2.0 * this.intrinsic.t2 * (n_dot_x * y + x * n_dot_y);
        }
        output[this.indexJacX++] = this.intrinsic.fx * xdot + this.intrinsic.skew * ydot;
        output[this.indexJacY++] = this.intrinsic.fy * ydot;
    }

    private void translateGradient(Point3D_F64 cameraPt, Point2D_F64 normPt, double[] output) {
        double r2;
        double x = normPt.x;
        double y = normPt.y;
        double r2i = r2 = x * x + y * y;
        double rdev = 1.0;
        double sum = 0.0;
        double sumdot = 0.0;
        for (int i = 0; i < this.intrinsic.radial.length; ++i) {
            sum += this.intrinsic.radial[i] * r2i;
            sumdot += this.intrinsic.radial[i] * (double)(i + 1) * rdev;
            r2i *= r2;
            rdev *= r2;
        }
        double xdot = sumdot * 2.0 * x * x / cameraPt.z + (1.0 + sum) / cameraPt.z;
        double ydot = sumdot * 2.0 * x * y / cameraPt.z;
        if (this.param.includeTangential) {
            xdot += (2.0 * this.intrinsic.t1 * y + this.intrinsic.t2 * 6.0 * x) / cameraPt.z;
            ydot += (2.0 * this.intrinsic.t1 * x + 2.0 * y * this.intrinsic.t2) / cameraPt.z;
        }
        output[this.indexJacX++] = this.intrinsic.fx * xdot + this.intrinsic.skew * ydot;
        output[this.indexJacY++] = this.intrinsic.fy * ydot;
        xdot = sumdot * 2.0 * y * x / cameraPt.z;
        ydot = sumdot * 2.0 * y * y / cameraPt.z + (1.0 + sum) / cameraPt.z;
        if (this.param.includeTangential) {
            xdot += (2.0 * this.intrinsic.t1 * x + this.intrinsic.t2 * 2.0 * y) / cameraPt.z;
            ydot += (6.0 * this.intrinsic.t1 * y + 2.0 * x * this.intrinsic.t2) / cameraPt.z;
        }
        output[this.indexJacX++] = this.intrinsic.fx * xdot + this.intrinsic.skew * ydot;
        output[this.indexJacY++] = this.intrinsic.fy * ydot;
        xdot = -sumdot * 2.0 * r2 * x / cameraPt.z;
        ydot = -sumdot * 2.0 * r2 * y / cameraPt.z;
        xdot += -(1.0 + sum) * x / cameraPt.z;
        ydot += -(1.0 + sum) * y / cameraPt.z;
        if (this.param.includeTangential) {
            xdot += -(4.0 * this.intrinsic.t1 * x * y + 6.0 * this.intrinsic.t2 * x * x + 2.0 * this.intrinsic.t2 * y * y) / cameraPt.z;
            ydot += -(2.0 * this.intrinsic.t1 * x * x + 6.0 * this.intrinsic.t1 * y * y + 4.0 * x * y * this.intrinsic.t2) / cameraPt.z;
        }
        output[this.indexJacX++] = this.intrinsic.fx * xdot + this.intrinsic.skew * ydot;
        output[this.indexJacY++] = this.intrinsic.fy * ydot;
    }
}

