/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration.pinhole;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.Zhang99IntrinsicParam;
import boofcv.alg.geo.calibration.Zhang99OptimizationJacobian;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class CalibParamPinholeRadial
extends Zhang99IntrinsicParam {
    public CameraPinholeRadial intrinsic;
    private Point2D_F64 normPt = new Point2D_F64();
    public boolean includeTangential;

    public CalibParamPinholeRadial(boolean assumeZeroSkew, int numRadial, boolean includeTangential) {
        this.intrinsic = new CameraPinholeRadial(numRadial);
        this.assumeZeroSkew = assumeZeroSkew;
        this.includeTangential = includeTangential;
    }

    @Override
    public int getNumberOfRadial() {
        return this.intrinsic.radial.length;
    }

    @Override
    public void initialize(DMatrixRMaj K, double[] radial) {
        this.intrinsic.fx = K.get(0, 0);
        this.intrinsic.fy = K.get(1, 1);
        this.intrinsic.skew = this.assumeZeroSkew ? 0.0 : K.get(0, 1);
        this.intrinsic.cx = K.get(0, 2);
        this.intrinsic.cy = K.get(1, 2);
        if (radial.length != this.intrinsic.radial.length) {
            throw new RuntimeException("BUG!");
        }
        System.arraycopy(radial, 0, this.intrinsic.radial, 0, this.intrinsic.radial.length);
        this.intrinsic.t2 = 0.0;
        this.intrinsic.t1 = 0.0;
    }

    @Override
    public int numParameters() {
        int total = 4 + this.intrinsic.radial.length;
        if (!this.assumeZeroSkew) {
            ++total;
        }
        if (this.includeTangential) {
            total += 2;
        }
        return total;
    }

    @Override
    public int setFromParam(double[] param) {
        int index = 0;
        this.intrinsic.fx = param[index++];
        this.intrinsic.fy = param[index++];
        this.intrinsic.skew = !this.assumeZeroSkew ? param[index++] : 0.0;
        this.intrinsic.cx = param[index++];
        this.intrinsic.cy = param[index++];
        for (int i = 0; i < this.intrinsic.radial.length; ++i) {
            this.intrinsic.radial[i] = param[index++];
        }
        if (this.includeTangential) {
            this.intrinsic.t1 = param[index++];
            this.intrinsic.t2 = param[index++];
        } else {
            this.intrinsic.t1 = 0.0;
            this.intrinsic.t2 = 0.0;
        }
        return index;
    }

    @Override
    public int convertToParam(double[] param) {
        int index = 0;
        param[index++] = this.intrinsic.fx;
        param[index++] = this.intrinsic.fy;
        if (!this.assumeZeroSkew) {
            param[index++] = this.intrinsic.skew;
        }
        param[index++] = this.intrinsic.cx;
        param[index++] = this.intrinsic.cy;
        for (int i = 0; i < this.intrinsic.radial.length; ++i) {
            param[index++] = this.intrinsic.radial[i];
        }
        if (this.includeTangential) {
            param[index++] = this.intrinsic.t1;
            param[index++] = this.intrinsic.t2;
        }
        return index;
    }

    public CameraPinholeRadial getCameraModel() {
        return this.intrinsic;
    }

    @Override
    public Zhang99IntrinsicParam createLike() {
        return new CalibParamPinholeRadial(this.assumeZeroSkew, this.intrinsic.radial.length, this.includeTangential);
    }

    @Override
    public Zhang99OptimizationJacobian createJacobian(List<CalibrationObservation> observations, List<Point2D_F64> grid) {
        return new Zhang99OptimizationJacobian(this, observations, grid);
    }

    @Override
    public void setTo(Zhang99IntrinsicParam orig) {
        CalibParamPinholeRadial o = (CalibParamPinholeRadial)orig;
        this.intrinsic.set((CameraPinhole)o.intrinsic);
        this.includeTangential = o.includeTangential;
        this.assumeZeroSkew = o.assumeZeroSkew;
    }

    @Override
    public void forceProjectionUpdate() {
    }

    @Override
    public void project(Point3D_F64 cameraPt, Point2D_F64 pixel) {
        this.normPt.x = cameraPt.x / cameraPt.z;
        this.normPt.y = cameraPt.y / cameraPt.z;
        CalibrationPlanarGridZhang99.applyDistortion(this.normPt, this.intrinsic.radial, this.intrinsic.t1, this.intrinsic.t2);
        pixel.x = this.intrinsic.fx * this.normPt.x + this.intrinsic.skew * this.normPt.y + this.intrinsic.cx;
        pixel.y = this.intrinsic.fy * this.normPt.y + this.intrinsic.cy;
    }
}

