/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.StereoParameters;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;

public class CalibrateStereoPlanar {
    List<Se3_F64> viewLeft = new ArrayList<Se3_F64>();
    List<Se3_F64> viewRight = new ArrayList<Se3_F64>();
    CalibrateMonoPlanar calibLeft;
    CalibrateMonoPlanar calibRight;
    List<Point2D_F64> layout;

    public CalibrateStereoPlanar(List<Point2D_F64> layout) {
        this.calibLeft = new CalibrateMonoPlanar(layout);
        this.calibRight = new CalibrateMonoPlanar(layout);
        this.layout = layout;
    }

    public void reset() {
        this.viewLeft.clear();
        this.viewRight.clear();
        this.calibLeft.reset();
        this.calibRight.reset();
    }

    public void configure(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        this.calibLeft.configurePinhole(assumeZeroSkew, numRadialParam, includeTangential);
        this.calibRight.configurePinhole(assumeZeroSkew, numRadialParam, includeTangential);
    }

    public void addPair(CalibrationObservation left, CalibrationObservation right) {
        this.calibLeft.addImage(left);
        this.calibRight.addImage(right);
    }

    public StereoParameters process() {
        CameraPinholeBrown leftParam = this.calibrateMono(this.calibLeft, this.viewLeft);
        CameraPinholeBrown rightParam = this.calibrateMono(this.calibRight, this.viewRight);
        Se3_F64 rightToLeft = this.computeRightToLeft();
        return new StereoParameters(leftParam, rightParam, rightToLeft);
    }

    private CameraPinholeBrown calibrateMono(CalibrateMonoPlanar calib, List<Se3_F64> location) {
        CameraPinholeBrown intrinsic = (CameraPinholeBrown)calib.process();
        SceneStructureMetric structure = calib.getStructure();
        for (int i = 0; i < structure.getViews().size; ++i) {
            location.add(((SceneStructureMetric.View[])structure.getViews().data)[i].worldToView);
        }
        return intrinsic;
    }

    private Se3_F64 computeRightToLeft() {
        List<Point2D_F64> points2D = this.layout;
        ArrayList<Point3D_F64> points3D = new ArrayList<Point3D_F64>();
        for (Point2D_F64 p : points2D) {
            points3D.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        ArrayList<Point3D_F64> left = new ArrayList<Point3D_F64>();
        ArrayList<Point3D_F64> right = new ArrayList<Point3D_F64>();
        for (int i = 0; i < this.viewLeft.size(); ++i) {
            Se3_F64 worldToLeft = this.viewLeft.get(i);
            Se3_F64 worldToRight = this.viewRight.get(i);
            for (Point3D_F64 p : points3D) {
                Point3D_F64 l = SePointOps_F64.transform((Se3_F64)worldToLeft, (Point3D_F64)p, null);
                Point3D_F64 r = SePointOps_F64.transform((Se3_F64)worldToRight, (Point3D_F64)p, null);
                left.add(l);
                right.add(r);
            }
        }
        return FitSpecialEuclideanOps_F64.fitPoints3D(right, left);
    }

    public CalibrateMonoPlanar getCalibLeft() {
        return this.calibLeft;
    }

    public CalibrateMonoPlanar getCalibRight() {
        return this.calibRight;
    }

    public void printStatistics() {
        System.out.println("********** LEFT ************");
        this.calibLeft.printStatistics();
        System.out.println("********** RIGHT ************");
        this.calibRight.printStatistics();
    }
}

