/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricResidualFunction;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.RadialDistortionEstimateLinear;
import boofcv.alg.geo.calibration.Zhang99CalibrationMatrixFromHomographies;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import boofcv.alg.geo.calibration.Zhang99DecomposeHomography;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ejml.data.DMatrixRMaj;

public class CalibrationPlanarGridZhang99 {
    Zhang99Camera cameraGenerator;
    private Zhang99ComputeTargetHomography computeHomography;
    private Zhang99CalibrationMatrixFromHomographies computeK;
    private RadialDistortionEstimateLinear computeRadial;
    private Zhang99DecomposeHomography decomposeH = new Zhang99DecomposeHomography();
    public SceneStructureMetric structure;
    public SceneObservations observations;
    private Listener listener;
    private List<Point2D_F64> layout;
    private boolean robust = false;
    private PrintStream verbose = null;

    public CalibrationPlanarGridZhang99(List<Point2D_F64> layout, Zhang99Camera cameraGenerator) {
        this.cameraGenerator = cameraGenerator;
        this.layout = layout;
        this.computeHomography = new Zhang99ComputeTargetHomography(layout);
        this.computeK = new Zhang99CalibrationMatrixFromHomographies(cameraGenerator.isZeroSkew());
        this.computeRadial = new RadialDistortionEstimateLinear(layout, cameraGenerator.numRadial());
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean process(List<CalibrationObservation> observations) {
        if (!this.linearEstimate(observations)) {
            return false;
        }
        this.status("Non-linear refinement");
        return this.performBundleAdjustment();
    }

    protected boolean linearEstimate(List<CalibrationObservation> observations) {
        this.status("Estimating Homographies");
        ArrayList<DMatrixRMaj> homographies = new ArrayList<DMatrixRMaj>();
        ArrayList<Se3_F64> motions = new ArrayList<Se3_F64>();
        for (CalibrationObservation calibrationObservation : observations) {
            if (!this.computeHomography.computeHomography(calibrationObservation)) {
                return false;
            }
            DMatrixRMaj H = this.computeHomography.getHomography();
            homographies.add(H);
        }
        this.status("Estimating Calibration Matrix");
        this.computeK.process(homographies);
        DMatrixRMaj K = this.computeK.getCalibrationMatrix();
        this.decomposeH.setCalibrationMatrix(K);
        for (DMatrixRMaj H : homographies) {
            motions.add(this.decomposeH.decompose(H));
        }
        this.status("Estimating Radial Distortion");
        this.computeRadial.process(K, homographies, observations);
        double[] dArray = this.computeRadial.getParameters();
        this.convertIntoBundleStructure(motions, K, dArray, observations);
        return true;
    }

    private void status(String message) {
        if (this.listener != null && !this.listener.zhangUpdate(message)) {
            throw new RuntimeException("User requested termination of calibration");
        }
    }

    public boolean performBundleAdjustment() {
        BundleAdjustment bundleAdjustment;
        ConfigLevenbergMarquardt configLM = new ConfigLevenbergMarquardt();
        configLM.hessianScaling = false;
        ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
        configSBA.configOptimizer = configLM;
        if (this.robust) {
            configLM.mixture = 0.0;
            bundleAdjustment = FactoryMultiView.bundleDenseMetric((boolean)true, (ConfigBundleAdjustment)configSBA);
        } else {
            bundleAdjustment = FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)configSBA);
        }
        bundleAdjustment.setVerbose(this.verbose, 0);
        bundleAdjustment.configure(1.0E-20, 1.0E-20, 200);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        return bundleAdjustment.optimize((SceneStructure)this.structure);
    }

    public void convertIntoBundleStructure(List<Se3_F64> motions, DMatrixRMaj K, double[] distort, List<CalibrationObservation> obs) {
        this.structure = new SceneStructureMetric(false);
        this.structure.initialize(1, motions.size(), this.layout.size(), 1);
        this.observations = new SceneObservations();
        this.observations.initialize(motions.size(), true);
        this.structure.setCamera(0, false, this.cameraGenerator.initalizeCamera(K, distort));
        this.structure.setRigid(0, true, new Se3_F64(), this.layout.size());
        SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])this.structure.rigids.data)[0];
        for (int i = 0; i < this.layout.size(); ++i) {
            rigid.setPoint(i, this.layout.get((int)i).x, this.layout.get((int)i).y, 0.0);
        }
        for (int viewIdx = 0; viewIdx < motions.size(); ++viewIdx) {
            this.structure.setView(viewIdx, false, motions.get(viewIdx));
            SceneObservations.View v = this.observations.getViewRigid(viewIdx);
            this.structure.connectViewToCamera(viewIdx, 0);
            CalibrationObservation ca = obs.get(viewIdx);
            for (int j = 0; j < ca.size(); ++j) {
                PointIndex2D_F64 p = ca.get(j);
                v.add(p.index, (float)p.x, (float)p.y);
                this.structure.connectPointToView(p.index, viewIdx);
            }
        }
    }

    public List<ImageResults> computeErrors() {
        ArrayList<ImageResults> errors = new ArrayList<ImageResults>();
        double[] parameters = new double[this.structure.getParameterCount()];
        double[] residuals = new double[this.observations.getObservationCount() * 2];
        CodecSceneStructureMetric codec = new CodecSceneStructureMetric();
        codec.encode(this.structure, parameters);
        BundleAdjustmentMetricResidualFunction function = new BundleAdjustmentMetricResidualFunction();
        function.configure(this.structure, this.observations);
        function.process(parameters, residuals);
        int idx = 0;
        for (int i = 0; i < this.observations.viewsRigid.size; ++i) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.viewsRigid.data)[i];
            ImageResults r = new ImageResults(v.size());
            double sumX = 0.0;
            double sumY = 0.0;
            double meanErrorMag = 0.0;
            double maxError = 0.0;
            for (int j = 0; j < v.size(); ++j) {
                double x = residuals[idx++];
                double y = residuals[idx++];
                double nerr = r.pointError[j] = Math.sqrt(x * x + y * y);
                meanErrorMag += nerr;
                maxError = Math.max(maxError, nerr);
                sumX += x;
                sumY += y;
            }
            r.biasX = sumX / (double)v.size();
            r.biasY = sumY / (double)v.size();
            r.meanError = meanErrorMag / (double)v.size();
            r.maxError = maxError;
            errors.add(r);
        }
        return errors;
    }

    public CameraModel getCameraModel() {
        return this.cameraGenerator.getCameraModel(((SceneStructureCommon.Camera)this.structure.cameras.get((int)0)).model);
    }

    public static void applyDistortion(Point2D_F64 normPt, double[] radial, double t1, double t2) {
        double r2;
        double x = normPt.x;
        double y = normPt.y;
        double a = 0.0;
        double r2i = r2 = x * x + y * y;
        for (int i = 0; i < radial.length; ++i) {
            a += radial[i] * r2i;
            r2i *= r2;
        }
        normPt.x = x + x * a + 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
        normPt.y = y + y * a + t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public void setVerbose(PrintStream out, int level) {
        this.verbose = out;
    }

    public void setRobust(boolean robust) {
        this.robust = robust;
    }

    public static int totalPoints(List<CalibrationObservation> observations) {
        int total = 0;
        for (int i = 0; i < observations.size(); ++i) {
            total += observations.get(i).size();
        }
        return total;
    }

    public static interface Listener {
        public boolean zhangUpdate(String var1);
    }
}

