/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.selfcalib.SelfCalibrationBase;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraPinhole;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UtilOptimize;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrix4x4;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.equation.Equation;
import org.ejml.interfaces.SolveNullSpace;
import org.ejml.ops.ConvertDMatrixStruct;

public class RefineDualQuadraticAlgebra
extends SelfCalibrationBase {
    SolveNullSpace<DMatrixRMaj> nullspace = new SolveNullSpaceSvd_DDRM();
    DMatrixRMaj _Q = new DMatrixRMaj(4, 4);
    DMatrixRMaj p = new DMatrixRMaj(3, 1);
    UnconstrainedLeastSquares<DMatrixRMaj> optimizer = FactoryOptimization.levenbergMarquardt(null, (boolean)false);
    ResidualK func;
    DGrowArray param = new DGrowArray();
    ConfigConverge converge = new ConfigConverge(1.0E-6, 1.0E-5, 100);
    private boolean zeroPrinciplePoint = false;
    private boolean zeroSkew = false;
    private boolean fixedAspectRatio = false;
    DGrowArray aspect = new DGrowArray();
    int calibParameters;

    public boolean refine(List<CameraPinhole> calibration, DMatrix4x4 Q) {
        if (calibration.size() != this.cameras.size) {
            throw new RuntimeException("Calibration and cameras do not match");
        }
        this.computeNumberOfCalibrationParameters();
        this.func = new ResidualK();
        if (this.func.getNumOfInputsN() > 6 * calibration.size()) {
            throw new IllegalArgumentException("Need more views to refine. eqs=" + 3 * calibration.size() + " unknowns=" + this.func.getNumOfInputsN());
        }
        ConvertDMatrixStruct.convert((DMatrix4x4)Q, (DMatrixRMaj)this._Q);
        this.nullspace.process((Matrix)this._Q, 1, (Matrix)this.p);
        CommonOps_DDRM.divide((DMatrixD1)this.p, (double)this.p.get(3));
        this.p.numRows = 3;
        this.encode(calibration, this.p, this.param);
        this.optimizer.setFunction((FunctionNtoM)this.func, null);
        this.optimizer.initialize(this.param.data, this.converge.ftol, this.converge.gtol);
        if (!UtilOptimize.process(this.optimizer, (int)this.converge.maxIterations)) {
            return false;
        }
        this.decode(this.optimizer.getParameters(), calibration, this.p);
        this.recomputeQ(this.p, Q);
        return true;
    }

    private void computeNumberOfCalibrationParameters() {
        this.calibParameters = 0;
        if (!this.zeroPrinciplePoint) {
            this.calibParameters += 2;
        }
        if (!this.zeroSkew) {
            ++this.calibParameters;
        }
        this.calibParameters = this.fixedAspectRatio ? ++this.calibParameters : (this.calibParameters += 2);
    }

    void recomputeQ(DMatrixRMaj p, DMatrix4x4 Q) {
        Equation eq = new Equation();
        DMatrix3x3 K = new DMatrix3x3();
        this.encodeK(K, 0, 3, this.param.data);
        eq.alias(new Object[]{p, "p", K, "K"});
        eq.process("w=K*K'");
        eq.process("Q=[w , -w*p;-p'*w , p'*w*p]");
        DMatrixRMaj _Q = eq.lookupDDRM("Q");
        CommonOps_DDRM.divide((DMatrixD1)_Q, (double)NormOps_DDRM.normF((DMatrixD1)_Q));
        ConvertDMatrixStruct.convert((DMatrixRMaj)_Q, (DMatrix4x4)Q);
    }

    void encode(List<CameraPinhole> calibration, DMatrixRMaj p, DGrowArray params) {
        this.aspect.reshape(calibration.size());
        params.reshape(3 + calibration.size() * this.calibParameters);
        int idx = 0;
        params.data[idx++] = p.data[0];
        params.data[idx++] = p.data[1];
        params.data[idx++] = p.data[2];
        for (int i = 0; i < calibration.size(); ++i) {
            CameraPinhole K = calibration.get(i);
            if (this.fixedAspectRatio) {
                this.aspect.data[i] = K.fy / K.fx;
                params.data[idx++] = K.fx;
            } else {
                params.data[idx++] = K.fx;
                params.data[idx++] = K.fy;
            }
            if (!this.zeroSkew) {
                params.data[idx++] = K.skew;
            }
            if (this.zeroPrinciplePoint) continue;
            params.data[idx++] = K.cx;
            params.data[idx++] = K.cy;
        }
    }

    void decode(double[] params, List<CameraPinhole> calibration, DMatrixRMaj p) {
        int idx = 0;
        p.data[0] = params[idx++];
        p.data[1] = params[idx++];
        p.data[2] = params[idx++];
        for (int i = 0; i < calibration.size(); ++i) {
            CameraPinhole K = calibration.get(i);
            if (this.fixedAspectRatio) {
                K.fx = params[idx++];
                K.fy = this.aspect.data[i] * K.fx;
            } else {
                K.fx = params[idx++];
                K.fy = params[idx++];
            }
            K.skew = !this.zeroSkew ? params[idx++] : 0.0;
            if (!this.zeroPrinciplePoint) {
                K.cx = params[idx++];
                K.cy = params[idx++];
                continue;
            }
            K.cy = 0.0;
            K.cx = 0.0;
        }
    }

    public int encodeK(DMatrix3x3 K, int which, int offset, double[] params) {
        if (this.fixedAspectRatio) {
            K.a11 = params[offset++];
            K.a22 = this.aspect.data[which] * K.a11;
        } else {
            K.a11 = params[offset++];
            K.a22 = params[offset++];
        }
        if (!this.zeroSkew) {
            K.a12 = params[offset++];
        }
        if (!this.zeroPrinciplePoint) {
            K.a13 = params[offset++];
            K.a23 = params[offset++];
        }
        K.a33 = 1.0;
        return offset;
    }

    public ConfigConverge getConverge() {
        return this.converge;
    }

    public boolean isZeroPrinciplePoint() {
        return this.zeroPrinciplePoint;
    }

    public void setZeroPrinciplePoint(boolean zeroPrinciplePoint) {
        this.zeroPrinciplePoint = zeroPrinciplePoint;
    }

    public boolean isZeroSkew() {
        return this.zeroSkew;
    }

    public void setZeroSkew(boolean zeroSkew) {
        this.zeroSkew = zeroSkew;
    }

    public boolean isFixedAspectRatio() {
        return this.fixedAspectRatio;
    }

    public void setFixedAspectRatio(boolean fixedAspectRatio) {
        this.fixedAspectRatio = fixedAspectRatio;
    }

    private class ResidualK
    implements FunctionNtoM {
        Equation eq = new Equation();
        DMatrix3x3 K = new DMatrix3x3();
        DMatrix3 p = new DMatrix3();

        private ResidualK() {
        }

        public void process(double[] input, double[] output) {
            this.p.set(input[0], input[1], input[2]);
            int indexInput = RefineDualQuadraticAlgebra.this.encodeK(this.K, 0, 3, input);
            this.eq.alias(new Object[]{this.p, "p", this.K, "K"});
            this.eq.process("w0=K*K'");
            int indexOut = 0;
            for (int i = 1; i < RefineDualQuadraticAlgebra.this.cameras.size; ++i) {
                SelfCalibrationBase.Projective P = (SelfCalibrationBase.Projective)RefineDualQuadraticAlgebra.this.cameras.get(i);
                indexInput = RefineDualQuadraticAlgebra.this.encodeK(this.K, i, indexInput, RefineDualQuadraticAlgebra.this.param.data);
                this.eq.alias(new Object[]{this.K, "K", P.A, "A", P.a, "a"});
                this.eq.process("AP = A-a*p'");
                this.eq.process("kk = K*K'/normF(K*K')");
                this.eq.process("AW = AP*w0*AP'");
                this.eq.process("AW = AW / normF(AW)");
                this.eq.process("R = kk-AW");
                DMatrixRMaj residual = this.eq.lookupDDRM("R");
                output[indexOut++] = residual.get(0, 0);
                output[indexOut++] = residual.get(0, 1);
                output[indexOut++] = residual.get(0, 2);
                output[indexOut++] = residual.get(1, 1);
                output[indexOut++] = residual.get(1, 2);
                output[indexOut++] = residual.get(2, 2);
            }
        }

        public int getNumOfInputsN() {
            return 3 + RefineDualQuadraticAlgebra.this.calibParameters * RefineDualQuadraticAlgebra.this.cameras.size;
        }

        public int getNumOfOutputsM() {
            return 6 * RefineDualQuadraticAlgebra.this.cameras.size;
        }
    }
}

