/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.disparity;

import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.alg.feature.disparity.DisparitySparseScoreSadRect;
import boofcv.alg.feature.disparity.DisparitySparseSelect;
import boofcv.struct.image.ImageGray;

public class WrapDisparitySparseSadRect<ArrayData, T extends ImageGray>
implements StereoDisparitySparse<T> {
    DisparitySparseScoreSadRect<ArrayData, T> computeScore;
    DisparitySparseSelect<ArrayData> select;
    double minDisparityFloat;

    public WrapDisparitySparseSadRect(DisparitySparseScoreSadRect<ArrayData, T> computeScore, DisparitySparseSelect<ArrayData> select) {
        this.computeScore = computeScore;
        this.select = select;
    }

    @Override
    public void setImages(T imageLeft, T imageRight) {
        this.computeScore.setImages(imageLeft, imageRight);
        this.minDisparityFloat = this.computeScore.getMinDisparity();
    }

    @Override
    public double getDisparity() {
        return this.minDisparityFloat + this.select.getDisparity();
    }

    @Override
    public boolean process(int x, int y) {
        if (this.computeScore.process(x, y)) {
            return this.select.select(this.computeScore.getScore(), this.computeScore.getLocalMaxDisparity());
        }
        return false;
    }

    @Override
    public int getBorderX() {
        return this.computeScore.getRadiusX();
    }

    @Override
    public int getBorderY() {
        return this.computeScore.getRadiusY();
    }

    @Override
    public int getMinDisparity() {
        return this.computeScore.getMinDisparity();
    }

    @Override
    public int getMaxDisparity() {
        return this.computeScore.getMaxDisparity();
    }

    @Override
    public Class<T> getInputType() {
        return this.computeScore.getImageType();
    }
}

