/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.FastHelper;
import boofcv.struct.image.GrayF32;

public class ImplFastHelper_F32
implements FastHelper<GrayF32> {
    private GrayF32 image;
    private float pixelTol;
    private float lower;
    private float upper;
    private float centerValue;
    private int[] offsets;

    public ImplFastHelper_F32(int pixelTol) {
        this.pixelTol = pixelTol;
    }

    @Override
    public void setImage(GrayF32 image, int[] offsets) {
        this.image = image;
        this.offsets = offsets;
    }

    @Override
    public void setThresholds(int index) {
        this.centerValue = this.image.data[index];
        this.lower = this.centerValue - this.pixelTol;
        this.upper = this.centerValue + this.pixelTol;
    }

    @Override
    public float scoreLower(int index) {
        int total = 0;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            float v = this.image.data[index + this.offsets[i]];
            if (!(v < this.lower)) continue;
            total = (int)((float)total + v);
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return this.centerValue * (float)count - (float)total;
    }

    @Override
    public float scoreUpper(int index) {
        int total = 0;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            float v = this.image.data[index + this.offsets[i]];
            if (!(v > this.upper)) continue;
            total = (int)((float)total + v);
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return (float)total - this.centerValue * (float)count;
    }

    @Override
    public boolean checkPixelLower(int index) {
        return this.image.data[index] < this.lower;
    }

    @Override
    public boolean checkPixelUpper(int index) {
        return this.image.data[index] > this.upper;
    }
}

