/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.ellipse;

import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.LinearContourLabelChang2004;
import boofcv.struct.ConnectRule;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import georegression.fitting.ellipse.ClosestPointEllipseAngle_F64;
import georegression.fitting.ellipse.FitEllipseAlgebraic_F64;
import georegression.geometry.UtilEllipse_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.EllipseQuadratic_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class BinaryEllipseDetectorPixel {
    private double maxDistanceFromEllipse = 3.0;
    private int minimumContour = 20;
    private int maximumContour = 0;
    private double maxMajorToMinorRatio = Double.MAX_VALUE;
    private boolean internalContour = false;
    private LinearContourLabelChang2004 contourFinder = new LinearContourLabelChang2004(ConnectRule.FOUR);
    private GrayS32 labeled = new GrayS32(1, 1);
    private FitEllipseAlgebraic_F64 algebraic = new FitEllipseAlgebraic_F64();
    private ClosestPointEllipseAngle_F64 closestPoint = new ClosestPointEllipseAngle_F64((double)1.0E-4f, 15);
    protected PixelTransform2_F32 distToUndist;
    private boolean verbose = false;
    private FastQueue<Point2D_F64> pointsF = new FastQueue(Point2D_F64.class, true);
    private FastQueue<Found> found = new FastQueue(Found.class, true);

    public void setLensDistortion(PixelTransform2_F32 distToUndist) {
        this.distToUndist = distToUndist;
    }

    public void process(GrayU8 binary) {
        this.found.reset();
        this.labeled.reshape(binary.width, binary.height);
        this.contourFinder.process(binary, this.labeled);
        FastQueue blobs = this.contourFinder.getContours();
        for (int i = 0; i < blobs.size; ++i) {
            Contour c = (Contour)blobs.get(i);
            this.proccessContour(c.external);
            if (!this.internalContour) continue;
            for (int j = 0; j < c.internal.size(); ++j) {
                this.proccessContour((List)c.internal.get(j));
            }
        }
    }

    private void proccessContour(List<Point2D_I32> contour) {
        if (contour.size() < this.minimumContour || this.maximumContour > 0 && contour.size() > this.maximumContour) {
            if (this.verbose) {
                System.out.println("Rejecting: too small (or large) " + contour.size());
            }
            return;
        }
        if (this.touchesBorder(contour)) {
            return;
        }
        this.pointsF.reset();
        this.undistortContour(contour, this.pointsF);
        if (!this.algebraic.process(this.pointsF.toList())) {
            if (this.verbose) {
                System.out.println("Rejecting: algebraic fit failed. size = " + this.pointsF.size());
            }
            return;
        }
        EllipseQuadratic_F64 quad = this.algebraic.getEllipse();
        Found f = (Found)this.found.grow();
        UtilEllipse_F64.convert((EllipseQuadratic_F64)quad, (EllipseRotated_F64)f.ellipse);
        if (!this.isApproximatelyElliptical(f.ellipse, this.pointsF.toList(), 20)) {
            if (this.verbose) {
                System.out.println("Rejecting: Not approximately elliptical. size = " + this.pointsF.size());
            }
            this.found.removeTail();
        } else if (f.ellipse.a > this.maxMajorToMinorRatio * f.ellipse.b) {
            if (this.verbose) {
                System.out.println("Rejecting: Major to minor axis length ratio too extreme = " + this.pointsF.size());
            }
            this.found.removeTail();
        }
        if (this.verbose) {
            System.out.println("Success!  size = " + this.pointsF.size());
        }
        f.contour = contour;
    }

    protected final boolean touchesBorder(List<Point2D_I32> contour) {
        int endX = this.labeled.width - 1;
        int endY = this.labeled.height - 1;
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            if (p.x != 0 && p.y != 0 && p.x != endX && p.y != endY) continue;
            return true;
        }
        return false;
    }

    void undistortContour(List<Point2D_I32> external, FastQueue<Point2D_F64> pointsF) {
        for (int j = 0; j < external.size(); ++j) {
            Point2D_I32 p = external.get(j);
            if (this.distToUndist != null) {
                this.distToUndist.compute(p.x, p.y);
                ((Point2D_F64)pointsF.grow()).set((double)this.distToUndist.distX, (double)this.distToUndist.distY);
                continue;
            }
            ((Point2D_F64)pointsF.grow()).set((double)p.x, (double)p.y);
        }
    }

    boolean isApproximatelyElliptical(EllipseRotated_F64 ellipse, List<Point2D_F64> points, int maxSamples) {
        this.closestPoint.setEllipse(ellipse);
        double maxDistance2 = this.maxDistanceFromEllipse * this.maxDistanceFromEllipse;
        if (points.size() <= maxSamples) {
            for (int i = 0; i < points.size(); ++i) {
                Point2D_F64 p = points.get(i);
                this.closestPoint.process(p);
                double d = this.closestPoint.getClosest().distance2((GeoTuple2D_F64)p);
                if (!(d > maxDistance2)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < maxSamples; ++i) {
                Point2D_F64 p = points.get(i * points.size() / maxSamples);
                this.closestPoint.process(p);
                double d = this.closestPoint.getClosest().distance2((GeoTuple2D_F64)p);
                if (!(d > maxDistance2)) continue;
                return false;
            }
        }
        return true;
    }

    public LinearContourLabelChang2004 getContourFinder() {
        return this.contourFinder;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isInternalContour() {
        return this.internalContour;
    }

    public void setInternalContour(boolean internalContour) {
        this.internalContour = internalContour;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public double getMaxDistanceFromEllipse() {
        return this.maxDistanceFromEllipse;
    }

    public void setMaxDistanceFromEllipse(double maxDistanceFromEllipse) {
        this.maxDistanceFromEllipse = maxDistanceFromEllipse;
    }

    public int getMinimumContour() {
        return this.minimumContour;
    }

    public void setMinimumContour(int minimumContour) {
        this.minimumContour = minimumContour;
    }

    public int getMaximumContour() {
        return this.maximumContour;
    }

    public void setMaximumContour(int maximumContour) {
        this.maximumContour = maximumContour;
    }

    public double getMaxMajorToMinorRatio() {
        return this.maxMajorToMinorRatio;
    }

    public void setMaxMajorToMinorRatio(double maxMajorToMinorRatio) {
        this.maxMajorToMinorRatio = maxMajorToMinorRatio;
    }

    public List<Found> getFound() {
        return this.found.toList();
    }

    public static class Found {
        public EllipseRotated_F64 ellipse = new EllipseRotated_F64();
        public List<Point2D_I32> contour;
    }
}

