/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.ellipse;

import boofcv.alg.shapes.edge.BaseIntegralEdge;
import boofcv.struct.image.ImageGray;
import georegression.fitting.ellipse.FitEllipseWeightedAlgebraic_F64;
import georegression.geometry.UtilEllipse_F64;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseQuadratic_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;

public class SnapToEllipseEdge<T extends ImageGray<T>>
extends BaseIntegralEdge<T> {
    protected int maxIterations = 10;
    protected double convergenceTol = 1.0E-6;
    protected int numSampleContour;
    protected int radialSamples;
    protected GrowQueue_F64 weights = new GrowQueue_F64();
    protected FastQueue<Point2D_F64> samplePts = new FastQueue(Point2D_F64.class, true);
    protected FitEllipseWeightedAlgebraic_F64 fitter = new FitEllipseWeightedAlgebraic_F64();
    protected EllipseRotated_F64 previous = new EllipseRotated_F64();

    public SnapToEllipseEdge(int numSampleContour, int radialSamples, Class<T> imageType) {
        super(imageType);
        this.numSampleContour = numSampleContour;
        this.radialSamples = radialSamples;
    }

    public boolean process(EllipseRotated_F64 input, EllipseRotated_F64 refined) {
        refined.set(input);
        this.previous.set(input);
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            refined.set(this.previous);
            this.computePointsAndWeights(refined);
            if (this.fitter.process(this.samplePts.toList(), this.weights.data)) {
                UtilEllipse_F64.convert((EllipseQuadratic_F64)this.fitter.getEllipse(), (EllipseRotated_F64)refined);
                double scale = this.previous.a;
                refined.center.x = refined.center.x * scale + this.previous.center.x;
                refined.center.y = refined.center.y * scale + this.previous.center.y;
                refined.a *= scale;
                refined.b *= scale;
            } else {
                return false;
            }
            if (SnapToEllipseEdge.change(this.previous, refined) <= this.convergenceTol) {
                return true;
            }
            this.previous.set(refined);
        }
        return true;
    }

    protected static double change(EllipseRotated_F64 a, EllipseRotated_F64 b) {
        double total = 0.0;
        total += Math.abs(a.center.x - b.center.x);
        total += Math.abs(a.center.y - b.center.y);
        total += Math.abs(a.a - b.a);
        total += Math.abs(a.b - b.b);
        double weight = Math.min(4.0, 2.0 * (a.a / a.b - 1.0));
        return total += weight * UtilAngle.distHalf((double)a.phi, (double)b.phi);
    }

    void computePointsAndWeights(EllipseRotated_F64 ellipse) {
        double localScale = ellipse.a;
        this.samplePts.reset();
        this.weights.reset();
        int numSamples = this.radialSamples * 2 + 2;
        int numPts = numSamples - 1;
        Point2D_F64 sample = new Point2D_F64();
        for (int i = 0; i < this.numSampleContour; ++i) {
            double theta = Math.PI * 2 * (double)i / (double)this.numSampleContour;
            UtilEllipse_F64.computePoint((double)theta, (EllipseRotated_F64)ellipse, (Point2D_F64)sample);
            double tanX = sample.x - ellipse.center.x;
            double tanY = sample.y - ellipse.center.y;
            double r = Math.sqrt(tanX * tanX + tanY * tanY);
            double x = sample.x - (double)numSamples * (tanX /= r) / 2.0;
            double y = sample.y - (double)numSamples * (tanY /= r) / 2.0;
            double lengthX = (double)numSamples * tanX;
            double lengthY = (double)numSamples * tanY;
            if (!this.integral.isInside(x, y) || !this.integral.isInside(x + lengthX, y + lengthY)) continue;
            double sample0 = this.integral.compute(x, y, x + tanX, y + tanY);
            x += tanX;
            y += tanY;
            for (int j = 0; j < numPts; ++j) {
                double sample1 = this.integral.compute(x, y, x + tanX, y + tanY);
                double w = sample0 - sample1;
                if (w < 0.0) {
                    w = -w;
                }
                if (w > 0.0) {
                    ((Point2D_F64)this.samplePts.grow()).set((x - ellipse.center.x) / localScale, (y - ellipse.center.y) / localScale);
                    this.weights.add(w);
                }
                x += tanX;
                y += tanY;
                sample0 = sample1;
            }
        }
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getConvergenceTol() {
        return this.convergenceTol;
    }

    public void setConvergenceTol(double convergenceTol) {
        this.convergenceTol = convergenceTol;
    }
}

