/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.abst.feature.dense.DescribeImageDenseHoG;
import boofcv.abst.feature.dense.DescribeImageDenseSift;
import boofcv.abst.feature.dense.DescribeImageDense_Convert;
import boofcv.abst.feature.dense.GenericDenseDescribeImageDense;
import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.dense.BaseDenseHog;
import boofcv.alg.feature.dense.DescribeDenseSiftAlg;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.dense.ConfigDenseHoG;
import boofcv.factory.feature.dense.ConfigDenseSift;
import boofcv.factory.feature.dense.ConfigDenseSurfFast;
import boofcv.factory.feature.dense.ConfigDenseSurfStable;
import boofcv.factory.feature.dense.FactoryDescribeImageDenseAlg;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class FactoryDescribeImageDense {
    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribeImageDense<T, TupleDesc_F64> surfFast(ConfigDenseSurfFast config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigDenseSurfFast();
        }
        DescribeRegionPoint<T, BrightFeature> surf = FactoryDescribeRegionPoint.surfFast(config.surf, imageType);
        return new GenericDenseDescribeImageDense<T, BrightFeature>(surf, 2.0, config.descriptorScale, config.sampling.periodX, config.sampling.periodY);
    }

    public static <T extends ImageGray<T>, II extends ImageGray<II>> DescribeImageDense<T, TupleDesc_F64> surfStable(ConfigDenseSurfStable config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigDenseSurfStable();
        }
        config.checkValidity();
        DescribeRegionPoint<T, BrightFeature> surf = FactoryDescribeRegionPoint.surfStable(config.surf, imageType);
        return new GenericDenseDescribeImageDense<T, BrightFeature>(surf, 2.0, config.descriptorScale, config.sampling.periodX, config.sampling.periodY);
    }

    public static <T extends ImageGray<T>> DescribeImageDense<T, TupleDesc_F64> sift(ConfigDenseSift config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigDenseSift();
        }
        config.checkValidity();
        ConfigSiftDescribe c = config.sift;
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        DescribeDenseSiftAlg alg = new DescribeDenseSiftAlg(c.widthSubregion, c.widthGrid, c.numHistogramBins, c.weightingSigmaFraction, c.maxDescriptorElementValue, 1.0, 1.0, derivType);
        return new DescribeImageDenseSift(alg, config.sampling.periodX, config.sampling.periodY, imageType);
    }

    public static <T extends ImageBase<T>> DescribeImageDense<T, TupleDesc_F64> hog(ConfigDenseHoG config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigDenseHoG();
        }
        config.checkValidity();
        ImageType actualType = imageType.getDataType() != ImageDataType.F32 ? new ImageType(imageType.getFamily(), ImageDataType.F32, imageType.getNumBands()) : imageType;
        BaseDenseHog hog = config.fastVariant ? FactoryDescribeImageDenseAlg.hogFast(config, actualType) : FactoryDescribeImageDenseAlg.hog(config, actualType);
        DescribeImageDenseHoG<T> output = new DescribeImageDenseHoG<T>(hog);
        if (actualType != imageType) {
            return new DescribeImageDense_Convert(output, imageType);
        }
        return output;
    }
}

