/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLineHoughFoot;
import boofcv.abst.feature.detect.line.DetectLineHoughFootSubimage;
import boofcv.abst.feature.detect.line.DetectLineHoughPolar;
import boofcv.abst.feature.detect.line.DetectLineSegmentsGridRansac;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.line.ConnectLinesGrid;
import boofcv.alg.feature.detect.line.GridRansacLineDetector;
import boofcv.alg.feature.detect.line.gridline.Edgel;
import boofcv.alg.feature.detect.line.gridline.GridLineModelDistance;
import boofcv.alg.feature.detect.line.gridline.GridLineModelFitter;
import boofcv.alg.feature.detect.line.gridline.ImplGridRansacLineDetector_F32;
import boofcv.alg.feature.detect.line.gridline.ImplGridRansacLineDetector_S16;
import boofcv.factory.feature.detect.line.ConfigHoughFoot;
import boofcv.factory.feature.detect.line.ConfigHoughFootSubimage;
import boofcv.factory.feature.detect.line.ConfigHoughPolar;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageGray;
import georegression.fitting.line.ModelManagerLinePolar2D_F32;
import georegression.struct.line.LinePolar2D_F32;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class FactoryDetectLineAlgs {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> DetectLineSegmentsGridRansac<I, D> lineRansac(int regionSize, double thresholdEdge, double thresholdAngle, boolean connectLines, Class<I> imageType, Class<D> derivType) {
        GridRansacLineDetector alg;
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        ModelManagerLinePolar2D_F32 manager = new ModelManagerLinePolar2D_F32();
        GridLineModelDistance distance = new GridLineModelDistance((float)thresholdAngle);
        GridLineModelFitter fitter = new GridLineModelFitter((float)thresholdAngle);
        Ransac matcher = new Ransac(123123L, (ModelManager)manager, (ModelGenerator)fitter, (DistanceFromModel)distance, 25, 1.0);
        if (derivType == GrayF32.class) {
            alg = new ImplGridRansacLineDetector_F32(regionSize, 10, (ModelMatcher<LinePolar2D_F32, Edgel>)matcher);
        } else if (derivType == GrayS16.class) {
            alg = new ImplGridRansacLineDetector_S16(regionSize, 10, (ModelMatcher<LinePolar2D_F32, Edgel>)matcher);
        } else {
            throw new IllegalArgumentException("Unsupported derivative type");
        }
        ConnectLinesGrid connect = null;
        if (connectLines) {
            connect = new ConnectLinesGrid(0.031415926535897934, 1.0, 8.0);
        }
        return new DetectLineSegmentsGridRansac<I, GrayF32>(alg, connect, gradient, thresholdEdge, imageType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> DetectLineHoughFoot<I, D> houghFoot(ConfigHoughFoot config, Class<I> imageType, Class<D> derivType) {
        if (config == null) {
            config = new ConfigHoughFoot();
        }
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        return new DetectLineHoughFoot(config.localMaxRadius, config.minCounts, config.minDistanceFromOrigin, config.thresholdEdge, config.maxLines, gradient);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> DetectLineHoughFootSubimage<I, D> houghFootSub(ConfigHoughFootSubimage config, Class<I> imageType, Class<D> derivType) {
        if (config == null) {
            config = new ConfigHoughFootSubimage();
        }
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        return new DetectLineHoughFootSubimage(config.localMaxRadius, config.minCounts, config.minDistanceFromOrigin, config.thresholdEdge, config.totalHorizontalDivisions, config.totalVerticalDivisions, config.maxLines, gradient);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> DetectLineHoughPolar<I, D> houghPolar(ConfigHoughPolar config, Class<I> imageType, Class<D> derivType) {
        if (config == null) {
            throw new IllegalArgumentException("This is no default since minCounts must be specified");
        }
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        return new DetectLineHoughPolar(config.localMaxRadius, config.minCounts, config.resolutionRange, config.resolutionAngle, config.thresholdEdge, config.maxLines, gradient);
    }
}

