/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.shapes.polyline;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.abst.shapes.polyline.PointsToPolyline;
import boofcv.alg.shapes.polyline.RefinePolyLineCorner;
import boofcv.alg.shapes.polyline.splitmerge.PolylineSplitMerge;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.GrowQueue_I32;

public class NewSplitMerge_to_PointsToPolyline
implements PointsToPolyline {
    PolylineSplitMerge alg;
    RefinePolyLineCorner refine;

    public NewSplitMerge_to_PointsToPolyline(ConfigPolylineSplitMerge config) {
        boolean loop = true;
        this.alg = new PolylineSplitMerge();
        this.alg.setMinimumSideLength(config.minimumSideLength);
        this.alg.setMaxNumberOfSideSamples(config.maxNumberOfSideSamples);
        this.alg.setMaxSides(Integer.MAX_VALUE);
        this.alg.setMinSides(3);
        this.alg.setExtraConsider(config.extraConsider);
        this.alg.setConvex(true);
        this.alg.setThresholdSideSplitScore(config.thresholdSideSplitScore);
        this.alg.setCornerScorePenalty(config.cornerScorePenalty);
        this.alg.setConvexTest(config.convexTest);
        this.alg.setMaxSideError(config.maxSideError);
        if (config.refineIterations > 0) {
            this.refine = new RefinePolyLineCorner(loop, config.refineIterations);
        }
    }

    @Override
    public boolean process(List<Point2D_I32> input, GrowQueue_I32 vertexes) {
        if (!this.alg.process(input)) {
            return false;
        }
        PolylineSplitMerge.CandidatePolyline best = this.alg.getBestPolyline();
        if (best == null) {
            return false;
        }
        vertexes.setTo(best.splits);
        return this.refine == null || this.refine.fit(input, vertexes);
    }

    @Override
    public void setMinimumSides(int minimum) {
        this.alg.setMinSides(minimum);
    }

    @Override
    public int getMinimumSides() {
        return this.alg.getMinSides();
    }

    @Override
    public void setMaximumSides(int maximum) {
        this.alg.setMaxSides(maximum);
    }

    @Override
    public int getMaximumSides() {
        return this.alg.getMaxSides();
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    @Override
    public void setConvex(boolean convex) {
        this.alg.setConvex(convex);
    }

    @Override
    public boolean isConvex() {
        return this.alg.isConvex();
    }
}

