/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background;

import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public abstract class BackgroundModel<T extends ImageBase<T>> {
    protected ImageType<T> imageType;
    protected byte unknownValue = 0;

    public BackgroundModel(ImageType<T> imageType) {
        this.imageType = imageType;
    }

    public abstract void reset();

    public int getUnknownValue() {
        return this.unknownValue & 0xFF;
    }

    public void setUnknownValue(int unknownValue) {
        if (unknownValue < 2 || unknownValue > 255) {
            throw new IllegalArgumentException("out of range. 2 to 255");
        }
        this.unknownValue = (byte)unknownValue;
    }

    public ImageType<T> getImageType() {
        return this.imageType;
    }
}

