/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;

public abstract class ImplSsdCornerWeighted_S16
implements GradientCornerIntensity<GrayS16> {
    int radius;
    Kernel1D_S32 kernel;
    GrayS32 imgXX = new GrayS32(1, 1);
    GrayS32 imgYY = new GrayS32(1, 1);
    GrayS32 imgXY = new GrayS32(1, 1);
    GrayS32 temp = new GrayS32(1, 1);
    protected int totalXX;
    protected int totalYY;
    protected int totalXY;

    public ImplSsdCornerWeighted_S16(int radius) {
        this.radius = radius;
        this.kernel = (Kernel1D_S32)FactoryKernelGaussian.gaussian(Kernel1D_S32.class, (double)-1.0, (int)radius);
    }

    @Override
    public void process(GrayS16 derivX, GrayS16 derivY, GrayF32 intensity) {
        int y;
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        int w = derivX.width;
        int h = derivX.height;
        this.imgXX.reshape(w, h);
        this.imgYY.reshape(w, h);
        this.imgXY.reshape(w, h);
        this.temp.reshape(w, h);
        intensity.reshape(w, h);
        int index = 0;
        for (y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int x = 0;
            while (x < w) {
                short dx = derivX.data[indexX++];
                short dy = derivY.data[indexY++];
                this.imgXX.data[index] = dx * dx;
                this.imgYY.data[index] = dy * dy;
                this.imgXY.data[index] = dx * dy;
                ++x;
                ++index;
            }
        }
        this.blur(this.imgXX, this.temp);
        this.blur(this.imgYY, this.temp);
        this.blur(this.imgXY, this.temp);
        index = 0;
        for (y = 0; y < h; ++y) {
            int x = 0;
            while (x < w) {
                this.totalXX = this.imgXX.data[index];
                this.totalYY = this.imgYY.data[index];
                this.totalXY = this.imgXY.data[index];
                intensity.data[index] = this.computeResponse();
                ++x;
                ++index;
            }
        }
    }

    protected abstract float computeResponse();

    private void blur(GrayS32 image, GrayS32 temp) {
        ConvolveNormalized.horizontal((Kernel1D_S32)this.kernel, (GrayS32)image, (GrayS32)temp);
        ConvolveNormalized.vertical((Kernel1D_S32)this.kernel, (GrayS32)temp, (GrayS32)image);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }
}

