/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.struct.FastQueue;

public class AdjustPolygonForThresholdBias {
    private FastQueue<LineSegment2D_F64> segments = new FastQueue(LineSegment2D_F64.class, true);
    private LineGeneral2D_F64 ga = new LineGeneral2D_F64();
    private LineGeneral2D_F64 gb = new LineGeneral2D_F64();
    private Point2D_F64 intersection = new Point2D_F64();

    public void process(Polygon2D_F64 polygon, boolean clockwise) {
        int jj;
        int ii;
        int N = polygon.size();
        this.segments.resize(N);
        int i = N - 1;
        int j = 0;
        while (j < N) {
            if (clockwise) {
                ii = i;
                jj = j;
            } else {
                ii = j;
                jj = i;
            }
            Point2D_F64 a = polygon.get(ii);
            Point2D_F64 b = polygon.get(jj);
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            double l = Math.sqrt(dx * dx + dy * dy);
            if (dx < 0.0) {
                dx = 0.0;
            }
            if (dy > 0.0) {
                dy = 0.0;
            }
            LineSegment2D_F64 s = (LineSegment2D_F64)this.segments.get(ii);
            s.a.x = a.x - dy / l;
            s.a.y = a.y + dx / l;
            s.b.x = b.x - dy / l;
            s.b.y = b.y + dx / l;
            i = j++;
        }
        i = N - 1;
        j = 0;
        while (j < N) {
            if (clockwise) {
                ii = i;
                jj = j;
            } else {
                ii = j;
                jj = i;
            }
            UtilLine2D_F64.convert((LineSegment2D_F64)((LineSegment2D_F64)this.segments.get(ii)), (LineGeneral2D_F64)this.ga);
            UtilLine2D_F64.convert((LineSegment2D_F64)((LineSegment2D_F64)this.segments.get(jj)), (LineGeneral2D_F64)this.gb);
            if (null != Intersection2D_F64.intersection((LineGeneral2D_F64)this.ga, (LineGeneral2D_F64)this.gb, (Point2D_F64)this.intersection) && this.intersection.distance2((GeoTuple2D_F64)polygon.get(jj)) < 20.0) {
                polygon.get(jj).set(this.intersection);
            }
            i = j++;
        }
    }
}

