/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.extract;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.extract.WrapperNonMaxCandidate;
import boofcv.abst.feature.detect.extract.WrapperNonMaximumBlock;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.alg.feature.detect.extract.NonMaxBlock;
import boofcv.alg.feature.detect.extract.NonMaxBlockRelaxed;
import boofcv.alg.feature.detect.extract.NonMaxBlockStrict;
import boofcv.alg.feature.detect.extract.NonMaxCandidate;
import boofcv.alg.feature.detect.extract.NonMaxCandidateRelaxed;
import boofcv.alg.feature.detect.extract.NonMaxCandidateStrict;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.factory.feature.detect.extract.BOverrideFactoryFeatureExtractor;
import boofcv.struct.image.ImageGray;

public class FactoryFeatureExtractor {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureDetector<I, D> general(GeneralFeatureIntensity<I, D> intensity, NonMaxSuppression extractor, int maxFeatures) {
        GeneralFeatureDetector<I, D> det = new GeneralFeatureDetector<I, D>(intensity, extractor);
        det.setMaxFeatures(maxFeatures);
        return det;
    }

    public static NonMaxSuppression nonmax(ConfigExtract config) {
        if (config == null) {
            config = new ConfigExtract();
        }
        config.checkValidity();
        if (BOverrideFactoryFeatureExtractor.nonmax != null) {
            return BOverrideFactoryFeatureExtractor.nonmax.process(config);
        }
        NonMaxBlock ret = config.useStrictRule ? (config.detectMaximums ? (config.detectMinimums ? new NonMaxBlockStrict.MinMax() : new NonMaxBlockStrict.Max()) : new NonMaxBlockStrict.Min()) : (config.detectMaximums ? (config.detectMinimums ? new NonMaxBlockRelaxed.MinMax() : new NonMaxBlockRelaxed.Max()) : new NonMaxBlockRelaxed.Min());
        ret.setSearchRadius(config.radius);
        ret.setThresholdMax(config.threshold);
        ret.setThresholdMin(-config.threshold);
        ret.setBorder(config.ignoreBorder);
        return new WrapperNonMaximumBlock(ret);
    }

    public static NonMaxSuppression nonmaxCandidate(ConfigExtract config) {
        if (config == null) {
            config = new ConfigExtract();
        }
        config.checkValidity();
        if (BOverrideFactoryFeatureExtractor.nonmaxCandidate != null) {
            return BOverrideFactoryFeatureExtractor.nonmaxCandidate.process(config);
        }
        NonMaxCandidate alg = config.useStrictRule ? new NonMaxCandidateStrict() : new NonMaxCandidateRelaxed();
        WrapperNonMaxCandidate ret = new WrapperNonMaxCandidate(alg, false, true);
        ret.setSearchRadius(config.radius);
        ret.setIgnoreBorder(config.ignoreBorder);
        ret.setThresholdMaximum(config.threshold);
        return ret;
    }

    public static NonMaxLimiter nonmaxLimiter(ConfigExtract config, int maxFeatures) {
        NonMaxSuppression nonmax = FactoryFeatureExtractor.nonmax(config);
        return new NonMaxLimiter(nonmax, maxFeatures);
    }
}

