/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.DisparityScoreWindowFive;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.impl.UtilDisparityScore;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class ImplDisparityScoreSadRectFive_U8<DI extends ImageGray<DI>>
extends DisparityScoreWindowFive<GrayU8, DI> {
    DisparitySelect<int[], DI> computeDisparity;
    int[] elementScore;
    int[][] horizontalScore;
    int[][] verticalScore;
    int activeVerticalScore;
    int[] fiveScore;

    public ImplDisparityScoreSadRectFive_U8(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<int[], DI> computeDisparity) {
        super(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
        this.computeDisparity = computeDisparity;
    }

    @Override
    public void _process(GrayU8 left, GrayU8 right, DI disparity) {
        if (this.horizontalScore == null || this.verticalScore.length < this.lengthHorizontal) {
            this.horizontalScore = new int[this.regionHeight][this.lengthHorizontal];
            this.verticalScore = new int[this.regionHeight][this.lengthHorizontal];
            this.elementScore = new int[left.width];
            this.fiveScore = new int[this.lengthHorizontal];
        }
        this.computeDisparity.configure(disparity, this.minDisparity, this.maxDisparity, this.radiusX * 2);
        this.computeFirstRow(left, right);
        this.computeRemainingRows(left, right);
    }

    private void computeFirstRow(GrayU8 left, GrayU8 right) {
        int[] firstRow = this.verticalScore[0];
        this.activeVerticalScore = 1;
        for (int row = 0; row < this.regionHeight; ++row) {
            int[] scores = this.horizontalScore[row];
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
        }
        for (int i = 0; i < this.lengthHorizontal; ++i) {
            int sum = 0;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += this.horizontalScore[row][i];
            }
            firstRow[i] = sum;
        }
    }

    private void computeRemainingRows(GrayU8 left, GrayU8 right) {
        int row = this.regionHeight;
        while (row < left.height) {
            int i;
            int oldRow = row % this.regionHeight;
            int[] previous = this.verticalScore[(this.activeVerticalScore - 1) % this.regionHeight];
            int[] active = this.verticalScore[this.activeVerticalScore % this.regionHeight];
            int[] scores = this.horizontalScore[oldRow];
            for (i = 0; i < this.lengthHorizontal; ++i) {
                active[i] = previous[i] - scores[i];
            }
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                active[n] = active[n] + scores[i];
            }
            if (this.activeVerticalScore >= this.regionHeight - 1) {
                int[] top = this.verticalScore[(this.activeVerticalScore - 2 * this.radiusY) % this.regionHeight];
                int[] middle = this.verticalScore[(this.activeVerticalScore - this.radiusY) % this.regionHeight];
                int[] bottom = this.verticalScore[this.activeVerticalScore % this.regionHeight];
                this.computeScoreFive(top, middle, bottom, this.fiveScore, left.width);
                this.computeDisparity.process(row - (1 + 4 * this.radiusY) + 2 * this.radiusY + 1, this.fiveScore);
            }
            ++row;
            ++this.activeVerticalScore;
        }
    }

    protected void computeScoreFive(int[] top, int[] middle, int[] bottom, int[] score, int width) {
        for (int d = this.minDisparity; d < this.maxDisparity; ++d) {
            int indexSrc = (d - this.minDisparity) * width + (d - this.minDisparity) + this.radiusX;
            int indexDst = (d - this.minDisparity) * width + (d - this.minDisparity);
            int end = indexSrc + (width - d - 4 * this.radiusX);
            while (indexSrc < end) {
                int temp;
                int s = 0;
                int val0 = top[indexSrc - this.radiusX];
                int val1 = top[indexSrc + this.radiusX];
                int val2 = bottom[indexSrc - this.radiusX];
                int val3 = bottom[indexSrc + this.radiusX];
                if (val1 < val0) {
                    temp = val0;
                    val0 = val1;
                    val1 = temp;
                }
                if (val3 < val2) {
                    temp = val2;
                    val2 = val3;
                    val3 = temp;
                }
                if (val3 < val0) {
                    s += val2;
                    s += val3;
                } else if (val2 < val1) {
                    s += val2;
                    s += val0;
                } else {
                    s += val0;
                    s += val1;
                }
                score[indexDst++] = s + middle[indexSrc++];
            }
        }
    }

    @Override
    public Class<GrayU8> getInputType() {
        return GrayU8.class;
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.computeDisparity.getDisparityType();
    }
}

