/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.abst.shapes.polyline.PointsToPolyline;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.binary.ContourPacked;
import boofcv.alg.shapes.polygon.ContourEdgeIntensity;
import boofcv.alg.shapes.polygon.PolygonHelper;
import boofcv.misc.MovingAverage;
import boofcv.struct.ConfigLength;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_I32;
import georegression.metric.Area2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_B;
import org.ddogleg.struct.GrowQueue_I32;

public class DetectPolygonFromContour<T extends ImageGray<T>> {
    private ConfigLength minimumContourConfig;
    private int minimumContour;
    private double minimumArea;
    private BinaryContourFinder contourFinder;
    private GrayS32 labeled = new GrayS32(1, 1);
    private PointsToPolyline contourToPolyline;
    private GrowQueue_I32 splits = new GrowQueue_I32();
    private ContourEdgeIntensity<T> contourEdgeIntensity;
    private FastQueue<Info> foundInfo = new FastQueue(Info.class, true);
    private boolean canTouchBorder;
    private Polygon2D_F64 polygonWork = new Polygon2D_F64();
    private Polygon2D_F64 polygonDistorted = new Polygon2D_F64();
    private boolean outputClockwise;
    protected PixelTransform2_F32 distToUndist;
    protected PixelTransform2_F32 undistToDist;
    private boolean verbose = false;
    double contourEdgeThreshold;
    private PolygonHelper helper;
    private FastQueue<Point2D_I32> undistorted = new FastQueue(Point2D_I32.class, true);
    private Class<T> inputType;
    private GrowQueue_B borderCorners = new GrowQueue_B();
    private FastQueue<Point2D_I32> contourTmp = new FastQueue(Point2D_I32.class, true);
    List<Point2D_I32> polygonPixel = new ArrayList<Point2D_I32>();
    MovingAverage milliContour = new MovingAverage(0.8);
    MovingAverage milliShapes = new MovingAverage(0.8);

    public DetectPolygonFromContour(PointsToPolyline contourToPolyline, ConfigLength minimumContour, boolean outputClockwise, boolean touchBorder, double contourEdgeThreshold, double tangentEdgeIntensity, BinaryContourFinder contourFinder, Class<T> inputType) {
        this.minimumContourConfig = minimumContour.copy();
        this.contourToPolyline = contourToPolyline;
        this.outputClockwise = outputClockwise;
        this.canTouchBorder = touchBorder;
        this.contourEdgeThreshold = contourEdgeThreshold;
        this.contourFinder = contourFinder;
        this.inputType = inputType;
        if (!this.contourToPolyline.isLoop()) {
            throw new IllegalArgumentException("ContourToPolygon must be configured for loops");
        }
        if (contourEdgeThreshold > 0.0) {
            this.contourEdgeIntensity = new ContourEdgeIntensity<T>(30, 1, tangentEdgeIntensity, inputType);
        }
        this.polygonWork = new Polygon2D_F64(1);
    }

    public void setLensDistortion(int width, int height, PixelTransform2_F32 distToUndist, PixelTransform2_F32 undistToDist) {
        this.distToUndist = distToUndist;
        this.undistToDist = undistToDist;
    }

    public void resetRuntimeProfiling() {
        this.milliContour.reset();
        this.milliShapes.reset();
    }

    public void clearLensDistortion() {
        this.distToUndist = null;
        this.undistToDist = null;
    }

    public void process(T gray, GrayU8 binary) {
        if (this.verbose) {
            System.out.println("ENTER  DetectPolygonFromContour.process()");
        }
        InputSanityCheck.checkSameShape((ImageBase)binary, gray);
        if (this.labeled.width != ((ImageGray)gray).width || this.labeled.height != ((ImageGray)gray).height) {
            this.configure(((ImageGray)gray).width, ((ImageGray)gray).height);
        }
        for (int i = 0; i < this.foundInfo.size; ++i) {
            ((Info)this.foundInfo.get(i)).reset();
        }
        this.foundInfo.reset();
        if (this.contourEdgeIntensity != null) {
            this.contourEdgeIntensity.setImage(gray);
        }
        long time0 = System.nanoTime();
        this.contourFinder.process(binary, this.labeled);
        long time1 = System.nanoTime();
        this.findCandidateShapes();
        long time2 = System.nanoTime();
        double a = (double)(time1 - time0) * 1.0E-6;
        double b = (double)(time2 - time1) * 1.0E-6;
        this.milliContour.update(a);
        this.milliShapes.update(b);
        if (this.verbose) {
            System.out.println("EXIT  DetectPolygonFromContour.process()");
        }
    }

    private void configure(int width, int height) {
        this.labeled.reshape(width, height);
        this.minimumContour = this.minimumContourConfig.computeI((double)Math.min(width, height));
        this.minimumContour = Math.max(4, this.minimumContour);
        this.minimumArea = Math.pow((double)this.minimumContour / 4.0, 2.0);
        this.contourFinder.setMinContour(this.minimumContour);
        if (this.helper != null) {
            this.helper.setImageShape(width, height);
        }
    }

    private void findCandidateShapes() {
        List blobs = this.contourFinder.getContours();
        for (int i = 0; i < blobs.size(); ++i) {
            List undistorted;
            ContourPacked c = (ContourPacked)blobs.get(i);
            this.contourTmp.reset();
            this.contourFinder.loadContour(c.externalIndex, this.contourTmp);
            if (this.contourTmp.size() < this.minimumContour) continue;
            float edgeInside = -1.0f;
            float edgeOutside = -1.0f;
            boolean touchesBorder = this.touchesBorder(this.contourTmp.toList());
            if (!this.canTouchBorder && touchesBorder) {
                if (!this.verbose) continue;
                System.out.println("rejected polygon, touched border");
                continue;
            }
            if (this.helper != null && !this.helper.filterContour(this.contourTmp.toList(), touchesBorder, true)) continue;
            if (this.contourEdgeIntensity != null) {
                this.contourEdgeIntensity.process(this.contourTmp.toList(), true);
                edgeInside = this.contourEdgeIntensity.getInsideAverage();
                edgeOutside = this.contourEdgeIntensity.getOutsideAverage();
                if ((double)Math.abs(edgeOutside - edgeInside) < this.contourEdgeThreshold) {
                    if (!this.verbose) continue;
                    System.out.println("rejected polygon. contour edge intensity");
                    continue;
                }
            }
            if (this.distToUndist != null) {
                undistorted = this.undistorted.toList();
                this.removeDistortionFromContour(this.contourTmp.toList(), this.undistorted);
                if (this.helper != null && !this.helper.filterContour(this.undistorted.toList(), touchesBorder, false)) {
                    continue;
                }
            } else {
                undistorted = this.contourTmp.toList();
            }
            if (this.helper != null) {
                this.helper.configureBeforePolyline(this.contourToPolyline, touchesBorder);
            }
            if (!this.contourToPolyline.process(undistorted, this.splits)) {
                if (!this.verbose) continue;
                System.out.println("rejected polygon initial fit failed. contour size = " + this.contourTmp.size());
                continue;
            }
            this.polygonPixel.clear();
            for (int j = 0; j < this.splits.size; ++j) {
                this.polygonPixel.add((Point2D_I32)undistorted.get(this.splits.get(j)));
            }
            boolean isCCW = UtilPolygons2D_I32.isCCW(this.polygonPixel);
            if (this.contourEdgeIntensity != null) {
                if (!isCCW) {
                    float tmp = edgeInside;
                    edgeInside = edgeOutside;
                    edgeOutside = tmp;
                }
                if (edgeInside > edgeOutside) {
                    if (!this.verbose) continue;
                    System.out.println("White blob. Rejected");
                    continue;
                }
            }
            if (this.outputClockwise == isCCW) {
                DetectPolygonFromContour.flip(this.splits.data, this.splits.size);
            }
            this.polygonWork.vertexes.resize(this.splits.size());
            this.polygonDistorted.vertexes.resize(this.splits.size());
            for (int j = 0; j < this.splits.size(); ++j) {
                Point2D_I32 p = (Point2D_I32)undistorted.get(this.splits.get(j));
                Point2D_I32 q = (Point2D_I32)this.contourTmp.get(this.splits.get(j));
                this.polygonWork.get(j).set((double)p.x, (double)p.y);
                this.polygonDistorted.get(j).set((double)q.x, (double)q.y);
            }
            if (touchesBorder) {
                this.determineCornersOnBorder(this.polygonDistorted, this.borderCorners);
            } else {
                this.borderCorners.resize(0);
            }
            if (this.helper != null && !this.helper.filterPixelPolygon(this.polygonWork, this.polygonDistorted, this.borderCorners, touchesBorder)) {
                if (!this.verbose) continue;
                System.out.println("rejected by helper.filterPixelPolygon()");
                continue;
            }
            double area = Area2D_F64.polygonSimple((Polygon2D_F64)this.polygonWork);
            if (area < this.minimumArea) {
                if (!this.verbose) continue;
                System.out.println("Rejected area");
                continue;
            }
            Info info = (Info)this.foundInfo.grow();
            if (this.distToUndist != null) {
                this.contourFinder.writeContour(c.externalIndex, undistorted);
            }
            info.splits.setTo(this.splits);
            info.contourTouchesBorder = touchesBorder;
            info.external = true;
            info.edgeInside = edgeInside;
            info.edgeOutside = edgeOutside;
            info.contour = c;
            info.polygon.set(this.polygonWork);
            info.polygonDistorted.set(this.polygonDistorted);
            info.borderCorners.setTo(this.borderCorners);
        }
    }

    public static void flip(int[] a, int N) {
        int H = N / 2;
        for (int i = 1; i <= H; ++i) {
            int j = N - i;
            int tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    void determineCornersOnBorder(Polygon2D_F64 polygon, GrowQueue_B onImageBorder) {
        onImageBorder.reset();
        for (int i = 0; i < polygon.size(); ++i) {
            Point2D_F64 p = polygon.get(i);
            onImageBorder.add(p.x <= 1.0 || p.y <= 1.0 || p.x >= (double)(this.labeled.width - 2) || p.y >= (double)(this.labeled.height - 2));
        }
    }

    public List<Point2D_I32> getContour(Info info) {
        this.contourTmp.reset();
        this.contourFinder.loadContour(info.contour.externalIndex, this.contourTmp);
        return this.contourTmp.toList();
    }

    private void removeDistortionFromContour(List<Point2D_I32> distorted, FastQueue<Point2D_I32> undistorted) {
        undistorted.reset();
        for (int j = 0; j < distorted.size(); ++j) {
            Point2D_I32 p = distorted.get(j);
            Point2D_I32 q = (Point2D_I32)undistorted.grow();
            this.distToUndist.compute(p.x, p.y);
            q.x = Math.round(this.distToUndist.distX);
            q.y = Math.round(this.distToUndist.distY);
        }
    }

    protected final boolean touchesBorder(List<Point2D_I32> contour) {
        int endX = this.labeled.width - 1;
        int endY = this.labeled.height - 1;
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            if (p.x != 0 && p.y != 0 && p.x != endX && p.y != endY) continue;
            return true;
        }
        return false;
    }

    public void setHelper(PolygonHelper helper) {
        this.helper = helper;
    }

    public boolean isConvex() {
        return this.contourToPolyline.isConvex();
    }

    public void setConvex(boolean convex) {
        this.contourToPolyline.setConvex(convex);
    }

    public GrayS32 getLabeled() {
        return this.labeled;
    }

    public boolean isOutputClockwise() {
        return this.outputClockwise;
    }

    public List<ContourPacked> getAllContours() {
        return this.contourFinder.getContours();
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public void setNumberOfSides(int min, int max) {
        if (min < 3) {
            throw new IllegalArgumentException("The min must be >= 3");
        }
        if (max < min) {
            throw new IllegalArgumentException("The max must be >= the min");
        }
        this.contourToPolyline.setMinimumSides(min);
        this.contourToPolyline.setMaximumSides(max);
    }

    public int getMinimumSides() {
        return this.contourToPolyline.getMinimumSides();
    }

    public int getMaximumSides() {
        return this.contourToPolyline.getMaximumSides();
    }

    public void setOutputClockwise(boolean outputClockwise) {
        this.outputClockwise = outputClockwise;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public double getContourEdgeThreshold() {
        return this.contourEdgeThreshold;
    }

    public void setContourEdgeThreshold(double contourEdgeThreshold) {
        this.contourEdgeThreshold = contourEdgeThreshold;
    }

    public PixelTransform2_F32 getDistToUndist() {
        return this.distToUndist;
    }

    public PixelTransform2_F32 getUndistToDist() {
        return this.undistToDist;
    }

    public FastQueue<Info> getFound() {
        return this.foundInfo;
    }

    public BinaryContourFinder getContourFinder() {
        return this.contourFinder;
    }

    public double getMilliContour() {
        return this.milliContour.getAverage();
    }

    public double getMilliShapes() {
        return this.milliShapes.getAverage();
    }

    public static class Info {
        public boolean external;
        public double edgeInside;
        public double edgeOutside;
        public boolean contourTouchesBorder;
        public GrowQueue_B borderCorners = new GrowQueue_B();
        public Polygon2D_F64 polygon = new Polygon2D_F64();
        public Polygon2D_F64 polygonDistorted = new Polygon2D_F64();
        public GrowQueue_I32 splits = new GrowQueue_I32();
        public ContourPacked contour;

        public double computeEdgeIntensity() {
            return this.edgeOutside - this.edgeInside;
        }

        public boolean hasInternal() {
            return this.contour.internalIndexes.size > 0;
        }

        public void reset() {
            this.external = false;
            this.edgeOutside = -1.0;
            this.edgeInside = -1.0;
            this.contourTouchesBorder = true;
            this.borderCorners.reset();
            this.splits.reset();
            this.polygon.vertexes.reset();
            this.polygonDistorted.vertexes.reset();
            this.contour = null;
        }
    }
}

