/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.describe;

import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.feature.describe.DescribePointBinaryCompare;
import boofcv.alg.feature.describe.DescribePointBrief;
import boofcv.alg.feature.describe.DescribePointBriefSO;
import boofcv.alg.feature.describe.DescribePointPixelRegion;
import boofcv.alg.feature.describe.DescribePointPixelRegionNCC;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.alg.feature.describe.impl.ImplDescribeBinaryCompare_F32;
import boofcv.alg.feature.describe.impl.ImplDescribeBinaryCompare_U8;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegionNCC_F32;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegionNCC_U8;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegion_F32;
import boofcv.alg.feature.describe.impl.ImplDescribePointPixelRegion_U8;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import javax.annotation.Nullable;

public class FactoryDescribePointAlgs {
    public static <T extends ImageGray<T>> DescribePointSurf<T> surfSpeed(@Nullable ConfigSurfDescribe.Speed config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigSurfDescribe.Speed();
        }
        config.checkValidity();
        return new DescribePointSurf<T>(config.widthLargeGrid, config.widthSubRegion, config.widthSample, config.weightSigma, config.useHaar, imageType);
    }

    public static <T extends ImageGray<T>> DescribePointSurfMod<T> surfStability(@Nullable ConfigSurfDescribe.Stability config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigSurfDescribe.Stability();
        }
        config.checkValidity();
        return new DescribePointSurfMod<T>(config.widthLargeGrid, config.widthSubRegion, config.widthSample, config.overLap, config.sigmaLargeGrid, config.sigmaSubRegion, config.useHaar, imageType);
    }

    public static <T extends ImageGray<T>> DescribePointSurfPlanar<T> surfColor(DescribePointSurf<T> describe, int numBands) {
        return new DescribePointSurfPlanar<T>(describe, numBands);
    }

    public static <T extends ImageGray<T>> DescribePointBrief<T> brief(BinaryCompareDefinition_I32 definition, BlurFilter<T> filterBlur) {
        DescribePointBinaryCompare compare;
        Class imageType = filterBlur.getInputType().getImageClass();
        if (imageType == GrayF32.class) {
            compare = new ImplDescribeBinaryCompare_F32(definition);
        } else if (imageType == GrayU8.class) {
            compare = new ImplDescribeBinaryCompare_U8(definition);
        } else {
            throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
        }
        return new DescribePointBrief<GrayF32>(compare, filterBlur);
    }

    public static <T extends ImageGray<T>> DescribePointBriefSO<T> briefso(BinaryCompareDefinition_I32 definition, BlurFilter<T> filterBlur) {
        Class imageType = filterBlur.getInputType().getImageClass();
        InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS((Class)imageType, (BorderType)BorderType.EXTENDED);
        return new DescribePointBriefSO<T>(definition, filterBlur, interp);
    }

    public static <T extends ImageGray<T>> DescribePointSift<T> sift(@Nullable ConfigSiftDescribe config, Class<T> derivType) {
        if (config == null) {
            config = new ConfigSiftDescribe();
        }
        return new DescribePointSift<T>(config.widthSubregion, config.widthGrid, config.numHistogramBins, config.sigmaToPixels, config.weightingSigmaFraction, config.maxDescriptorElementValue, derivType);
    }

    public static <T extends ImageGray<T>, D extends TupleDesc> DescribePointPixelRegion<T, D> pixelRegion(int regionWidth, int regionHeight, Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new ImplDescribePointPixelRegion_F32(regionWidth, regionHeight);
        }
        if (imageType == GrayU8.class) {
            return new ImplDescribePointPixelRegion_U8(regionWidth, regionHeight);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageGray<T>> DescribePointPixelRegionNCC<T> pixelRegionNCC(int regionWidth, int regionHeight, Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return new ImplDescribePointPixelRegionNCC_F32(regionWidth, regionHeight);
        }
        if (imageType == GrayU8.class) {
            return new ImplDescribePointPixelRegionNCC_U8(regionWidth, regionHeight);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }
}

