/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.descriptor;

import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;

public class ConvertDescriptors {
    public static void positive(TupleDesc_F64 input, TupleDesc_U8 output) {
        int i;
        double max = 0.0;
        for (i = 0; i < input.size(); ++i) {
            double v = input.value[i];
            if (!(v > max)) continue;
            max = v;
        }
        if (max == 0.0) {
            max = 1.0;
        }
        for (i = 0; i < input.size(); ++i) {
            output.value[i] = (byte)(255.0 * input.value[i] / max);
        }
    }

    public static void real(TupleDesc_F64 input, TupleDesc_S8 output) {
        int i;
        double max = 0.0;
        for (i = 0; i < input.size(); ++i) {
            double v = Math.abs(input.value[i]);
            if (!(v > max)) continue;
            max = v;
        }
        for (i = 0; i < input.size(); ++i) {
            output.value[i] = (byte)(127.0 * input.value[i] / max);
        }
    }

    public static void convertNcc(TupleDesc_F64 input, NccFeature output) {
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("Feature lengths do not match.");
        }
        double mean = 0.0;
        for (int i = 0; i < input.value.length; ++i) {
            mean += input.value[i];
        }
        mean /= (double)input.value.length;
        double variance = 0.0;
        for (int i = 0; i < input.value.length; ++i) {
            double d = output.value[i] = input.value[i] - mean;
            variance += d * d;
        }
        output.mean = mean;
        output.sigma = Math.sqrt(variance /= (double)output.size());
    }
}

