/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detdesc;

import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;

public class CompleteSift
extends SiftDetector {
    OrientationHistogramSift<GrayF32> orientation;
    DescribePointSift<GrayF32> describe;
    FastQueue<BrightFeature> features;
    FastQueue<ScalePoint> locations = new FastQueue(ScalePoint.class, false);
    GrowQueue_F64 orientations = new GrowQueue_F64();
    ImageGradient<GrayF32, GrayF32> gradient = FactoryDerivative.three(GrayF32.class, null);
    GrayF32 derivX = new GrayF32(1, 1);
    GrayF32 derivY = new GrayF32(1, 1);

    public CompleteSift(SiftScaleSpace scaleSpace, double edgeR, NonMaxLimiter extractor, OrientationHistogramSift<GrayF32> orientation, DescribePointSift<GrayF32> describe) {
        super(scaleSpace, edgeR, extractor);
        this.orientation = orientation;
        this.describe = describe;
        final int dof = describe.getDescriptorLength();
        this.features = new FastQueue<BrightFeature>(BrightFeature.class, true){

            protected BrightFeature createInstance() {
                return new BrightFeature(dof);
            }
        };
    }

    @Override
    public void process(GrayF32 input) {
        this.features.reset();
        this.locations.reset();
        this.orientations.reset();
        super.process(input);
    }

    @Override
    protected void detectFeatures(int scaleIndex) {
        GrayF32 input = this.scaleSpace.getImageScale(scaleIndex);
        this.derivX.reshape(input.width, input.height);
        this.derivY.reshape(input.width, input.height);
        this.gradient.process((ImageBase)input, (ImageBase)this.derivX, (ImageBase)this.derivY);
        this.orientation.setImageGradient(this.derivX, this.derivY);
        this.describe.setImageGradient(this.derivX, this.derivY);
        super.detectFeatures(scaleIndex);
    }

    @Override
    protected void handleDetection(ScalePoint p) {
        double localX = p.x / this.pixelScaleToInput;
        double localY = p.y / this.pixelScaleToInput;
        double localSigma = p.scale / this.pixelScaleToInput;
        this.orientation.process(localX, localY, localSigma);
        GrowQueue_F64 angles = this.orientation.getOrientations();
        for (int i = 0; i < angles.size; ++i) {
            BrightFeature feature = (BrightFeature)this.features.grow();
            feature.white = p.white;
            this.describe.process(localX, localY, localSigma, angles.get(i), feature);
            this.orientations.add(angles.get(i));
            this.locations.add((Object)p);
        }
    }

    public FastQueue<ScalePoint> getLocations() {
        return this.locations;
    }

    public FastQueue<BrightFeature> getDescriptions() {
        return this.features;
    }

    public GrowQueue_F64 getOrientations() {
        return this.orientations;
    }

    public int getDescriptorLength() {
        return this.describe.getDescriptorLength();
    }
}

