/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.DisparitySparseScoreSadRect;
import boofcv.struct.image.GrayF32;
import java.util.Arrays;

public class ImplDisparitySparseScoreSadRect_F32
extends DisparitySparseScoreSadRect<float[], GrayF32> {
    float[] scores;

    public ImplDisparitySparseScoreSadRect_F32(int minDisparity, int maxDisparity, int radiusX, int radiusY) {
        super(minDisparity, maxDisparity, radiusX, radiusY);
        this.scores = new float[maxDisparity];
    }

    @Override
    public boolean process(int x, int y) {
        this.localMaxDisparity = Math.min(this.rangeDisparity, x - this.radiusX + 1 - this.minDisparity);
        if (this.localMaxDisparity <= 0 || x >= ((GrayF32)this.left).width - this.radiusX || y < this.radiusY || y >= ((GrayF32)this.left).height - this.radiusY) {
            return false;
        }
        Arrays.fill(this.scores, 0.0f);
        for (int row = 0; row < this.regionHeight; ++row) {
            int startLeft = ((GrayF32)this.left).startIndex + ((GrayF32)this.left).stride * (y - this.radiusY + row) + x - this.radiusX;
            int startRight = ((GrayF32)this.right).startIndex + ((GrayF32)this.right).stride * (y - this.radiusY + row) + x - this.radiusX - this.minDisparity;
            int i = 0;
            while (i < this.localMaxDisparity) {
                int indexLeft = startLeft;
                int indexRight = startRight - i;
                float score = 0.0f;
                for (int j = 0; j < this.regionWidth; ++j) {
                    float diff = ((GrayF32)this.left).data[indexLeft++] - ((GrayF32)this.right).data[indexRight++];
                    score += Math.abs(diff);
                }
                int n = i++;
                this.scores[n] = this.scores[n] + score;
            }
        }
        return true;
    }

    @Override
    public float[] getScore() {
        return this.scores;
    }

    @Override
    public Class<GrayF32> getImageType() {
        return GrayF32.class;
    }
}

