/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.SelectRectStandard;
import boofcv.struct.image.ImageGray;

public abstract class ImplSelectRectStandardBase_S32<T extends ImageGray<T>>
extends SelectRectStandard<int[], T> {
    int[] columnScore = new int[1];
    int imageWidth;
    protected int textureThreshold;
    protected static final int discretizer = 10000;

    public ImplSelectRectStandardBase_S32(int maxError, int rightToLeftTolerance, double texture) {
        super(maxError, rightToLeftTolerance, texture);
    }

    @Override
    public void setTexture(double threshold) {
        this.textureThreshold = (int)(10000.0 * threshold);
    }

    @Override
    public void configure(T imageDisparity, int minDisparity, int maxDisparity, int radiusX) {
        super.configure(imageDisparity, minDisparity, maxDisparity, radiusX);
        if (this.columnScore.length < maxDisparity) {
            this.columnScore = new int[maxDisparity];
        }
        this.imageWidth = ((ImageGray)imageDisparity).width;
    }

    @Override
    public void process(int row, int[] scores) {
        int indexDisparity = this.imageDisparity.startIndex + row * this.imageDisparity.stride + this.radiusX + this.minDisparity;
        for (int col = this.minDisparity; col <= this.imageWidth - this.regionWidth; ++col) {
            int disparityRtoL;
            this.localMax = this.maxDisparityAtColumnL2R(col);
            int indexScore = col - this.minDisparity;
            int bestDisparity = 0;
            int scoreBest = this.columnScore[0] = scores[indexScore];
            indexScore += this.imageWidth;
            int i = 1;
            while (i < this.localMax) {
                int s;
                this.columnScore[i] = s = scores[indexScore];
                if (s < scoreBest) {
                    scoreBest = s;
                    bestDisparity = i;
                }
                ++i;
                indexScore += this.imageWidth;
            }
            if (scoreBest > this.maxError) {
                bestDisparity = this.invalidDisparity;
            } else if (this.rightToLeftTolerance >= 0 && Math.abs((disparityRtoL = this.selectRightToLeft(col - bestDisparity - this.minDisparity, scores)) - bestDisparity) > this.rightToLeftTolerance) {
                bestDisparity = this.invalidDisparity;
            }
            if (this.textureThreshold > 0 && bestDisparity != this.invalidDisparity && this.localMax >= 3) {
                int i2;
                int secondBest = Integer.MAX_VALUE;
                for (i2 = 0; i2 < bestDisparity - 1; ++i2) {
                    if (this.columnScore[i2] >= secondBest) continue;
                    secondBest = this.columnScore[i2];
                }
                for (i2 = bestDisparity + 2; i2 < this.localMax; ++i2) {
                    if (this.columnScore[i2] >= secondBest) continue;
                    secondBest = this.columnScore[i2];
                }
                if (10000 * (secondBest - scoreBest) <= this.textureThreshold * scoreBest) {
                    bestDisparity = this.invalidDisparity;
                }
            }
            this.setDisparity(indexDisparity++, bestDisparity);
        }
    }

    private int selectRightToLeft(int col, int[] scores) {
        int localMax = Math.min(this.imageWidth - this.regionWidth, col + this.maxDisparity) - col - this.minDisparity;
        int indexBest = 0;
        int indexScore = col;
        int scoreBest = scores[col];
        indexScore += this.imageWidth + 1;
        int i = 1;
        while (i < localMax) {
            int s = scores[indexScore];
            if (s < scoreBest) {
                scoreBest = s;
                indexBest = i;
            }
            ++i;
            indexScore += this.imageWidth + 1;
        }
        return indexBest;
    }
}

