/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.filter.binary.ContourPacked;
import boofcv.alg.shapes.edge.EdgeIntensityPolygon;
import boofcv.alg.shapes.polygon.AdjustPolygonForThresholdBias;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.alg.shapes.polygon.PolygonHelper;
import boofcv.alg.shapes.polygon.RefinePolygonToContour;
import boofcv.alg.shapes.polygon.RefinePolygonToGray;
import boofcv.misc.MovingAverage;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;

public class DetectPolygonBinaryGrayRefine<T extends ImageGray<T>> {
    DetectPolygonFromContour<T> detector;
    AdjustPolygonForThresholdBias adjustForBias;
    private RefinePolygonToContour refineContour;
    private RefinePolygonToGray<T> refineGray;
    private EdgeIntensityPolygon<T> edgeIntensity;
    private Polygon2D_F64 work = new Polygon2D_F64();
    AdjustBeforeRefineEdge functionAdjust;
    double minimumRefineEdgeIntensity;
    MovingAverage milliAdjustBias = new MovingAverage(0.8);

    public DetectPolygonBinaryGrayRefine(DetectPolygonFromContour<T> detector, RefinePolygonToContour refineContour, RefinePolygonToGray<T> refineGray, double minimumRefineEdgeIntensity, boolean adjustForThresholdBias) {
        this.detector = detector;
        this.refineContour = refineContour;
        this.refineGray = refineGray;
        this.minimumRefineEdgeIntensity = minimumRefineEdgeIntensity;
        if (adjustForThresholdBias) {
            this.adjustForBias = new AdjustPolygonForThresholdBias();
        }
        this.edgeIntensity = new EdgeIntensityPolygon<T>(1.0, 1.5, 15, detector.getInputType());
    }

    public void setHelper(PolygonHelper helper) {
        this.detector.setHelper(helper);
    }

    public void setVerbose(boolean verbose) {
        this.detector.setVerbose(verbose);
    }

    public void setLensDistortion(int width, int height, PixelTransform2_F32 distToUndist, PixelTransform2_F32 undistToDist) {
        this.detector.setLensDistortion(width, height, distToUndist, undistToDist);
        if (this.refineGray != null) {
            this.refineGray.setLensDistortion(width, height, distToUndist, undistToDist);
        }
        this.edgeIntensity.setTransform(undistToDist);
    }

    public void clearLensDistortion() {
        this.detector.clearLensDistortion();
        if (this.refineGray != null) {
            this.refineGray.clearLensDistortion();
        }
        this.edgeIntensity.setTransform(null);
    }

    public void resetRuntimeProfiling() {
        this.detector.resetRuntimeProfiling();
        this.milliAdjustBias.reset();
    }

    public void process(T gray, GrayU8 binary) {
        this.detector.process(gray, binary);
        if (this.refineGray != null) {
            this.refineGray.setImage(gray);
        }
        this.edgeIntensity.setImage(gray);
        long time0 = System.nanoTime();
        FastQueue<DetectPolygonFromContour.Info> detections = this.detector.getFound();
        if (this.adjustForBias != null) {
            int minSides = this.getMinimumSides();
            for (int i = detections.size() - 1; i >= 0; --i) {
                Polygon2D_F64 p = ((DetectPolygonFromContour.Info)detections.get((int)i)).polygon;
                this.adjustForBias.process(p, this.detector.isOutputClockwise());
                if (p.size() >= minSides) continue;
                detections.remove(i);
            }
        }
        long time1 = System.nanoTime();
        double milli = (double)(time1 - time0) * 1.0E-6;
        this.milliAdjustBias.update(milli);
    }

    public boolean refine(DetectPolygonFromContour.Info info) {
        double after;
        if (!this.edgeIntensity.computeEdge(info.polygon, !this.detector.isOutputClockwise())) {
            return false;
        }
        double before = this.edgeIntensity.getAverageOutside() - this.edgeIntensity.getAverageInside();
        boolean success = false;
        if (this.refineContour != null) {
            List<Point2D_I32> contour = this.detector.getContour(info);
            this.refineContour.process(contour, info.splits, this.work);
            if (this.adjustForBias != null) {
                this.adjustForBias.process(this.work, this.detector.isOutputClockwise());
            }
            if (this.edgeIntensity.computeEdge(this.work, !this.detector.isOutputClockwise()) && (after = this.edgeIntensity.getAverageOutside() - this.edgeIntensity.getAverageInside()) > before) {
                info.edgeInside = this.edgeIntensity.getAverageInside();
                info.edgeOutside = this.edgeIntensity.getAverageOutside();
                info.polygon.set(this.work);
                success = true;
                before = after;
            }
        }
        if (this.functionAdjust != null) {
            this.functionAdjust.adjust(info, this.detector.isOutputClockwise());
        }
        if (this.refineGray != null) {
            this.work.vertexes.resize(info.polygon.size());
            if (this.refineGray.refine(info.polygon, this.work) && this.edgeIntensity.computeEdge(this.work, !this.detector.isOutputClockwise()) && (after = this.edgeIntensity.getAverageOutside() - this.edgeIntensity.getAverageInside()) * 1.5 > before) {
                info.edgeInside = this.edgeIntensity.getAverageInside();
                info.edgeOutside = this.edgeIntensity.getAverageOutside();
                info.polygon.set(this.work);
                success = true;
            }
        }
        return success;
    }

    public void refineAll() {
        List detections = this.detector.getFound().toList();
        for (int i = 0; i < detections.size(); ++i) {
            this.refine((DetectPolygonFromContour.Info)detections.get(i));
        }
    }

    public List<Polygon2D_F64> getPolygons(@Nullable List<Polygon2D_F64> storage, @Nullable List<DetectPolygonFromContour.Info> storageInfo) {
        if (storage == null) {
            storage = new ArrayList<Polygon2D_F64>();
        } else {
            storage.clear();
        }
        if (storageInfo != null) {
            storageInfo.clear();
        }
        List detections = this.detector.getFound().toList();
        for (int i = 0; i < detections.size(); ++i) {
            DetectPolygonFromContour.Info d = (DetectPolygonFromContour.Info)detections.get(i);
            if (!(d.computeEdgeIntensity() >= this.minimumRefineEdgeIntensity)) continue;
            storage.add(d.polygon);
            if (storageInfo == null) continue;
            storageInfo.add(d);
        }
        return storage;
    }

    public List<DetectPolygonFromContour.Info> getPolygonInfo() {
        return this.detector.getFound().toList();
    }

    public Class<T> getInputType() {
        return this.detector.getInputType();
    }

    public int getMinimumSides() {
        return this.detector.getMinimumSides();
    }

    public int getMaximumSides() {
        return this.detector.getMaximumSides();
    }

    public boolean isOutputClockwise() {
        return this.detector.isOutputClockwise();
    }

    public DetectPolygonFromContour<T> getDetector() {
        return this.detector;
    }

    public List<ContourPacked> getAllContours() {
        return this.detector.getAllContours();
    }

    public void setFunctionAdjust(AdjustBeforeRefineEdge functionAdjust) {
        this.functionAdjust = functionAdjust;
    }

    public double getMilliAdjustBias() {
        return this.milliAdjustBias.getAverage();
    }

    public static interface AdjustBeforeRefineEdge {
        public void adjust(DetectPolygonFromContour.Info var1, boolean var2);
    }
}

