/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class AssociateNearestNeighbor<D>
implements AssociateDescription<D> {
    private NearestNeighbor<D> alg;
    private NnData<D> result = new NnData();
    private FastQueue<NnData<D>> result2 = new FastQueue(NnData.class, true);
    private FastQueue<D> listDst;
    int sizeSrc;
    boolean ratioUsesSqrt = true;
    double scoreRatioThreshold = 1.0;
    private FastQueue<AssociatedIndex> matches = new FastQueue(100, AssociatedIndex.class, true);
    private FindUnassociated unassociated = new FindUnassociated();
    private double maxDistance = -1.0;

    public AssociateNearestNeighbor(NearestNeighbor<D> alg) {
        this.alg = alg;
    }

    @Override
    public void setSource(FastQueue<D> listSrc) {
        this.sizeSrc = listSrc.size;
        this.alg.setPoints(listSrc.toList(), true);
    }

    @Override
    public void setDestination(FastQueue<D> listDst) {
        this.listDst = listDst;
    }

    @Override
    public void associate() {
        this.matches.resize(this.listDst.size);
        this.matches.reset();
        if (this.scoreRatioThreshold >= 1.0) {
            for (int i = 0; i < this.listDst.size; ++i) {
                if (!this.alg.findNearest(this.listDst.data[i], this.maxDistance, this.result)) continue;
                ((AssociatedIndex)this.matches.grow()).setAssociation(this.result.index, i, this.result.distance);
            }
        } else {
            for (int i = 0; i < this.listDst.size; ++i) {
                this.alg.findNearest(this.listDst.data[i], this.maxDistance, 2, this.result2);
                if (this.result2.size == 1) {
                    NnData r = (NnData)this.result2.getTail();
                    ((AssociatedIndex)this.matches.grow()).setAssociation(r.index, i, r.distance);
                    continue;
                }
                if (this.result2.size == 2) {
                    double foundRatio;
                    NnData r0 = (NnData)this.result2.get(0);
                    NnData r1 = (NnData)this.result2.get(1);
                    if (r0.distance > r1.distance) {
                        NnData tmp = r0;
                        r0 = r1;
                        r1 = tmp;
                    }
                    double d = foundRatio = this.ratioUsesSqrt ? Math.sqrt(r0.distance) / Math.sqrt(r1.distance) : r0.distance / r1.distance;
                    if (!(foundRatio <= this.scoreRatioThreshold)) continue;
                    ((AssociatedIndex)this.matches.grow()).setAssociation(r0.index, i, r0.distance);
                    continue;
                }
                if (this.result2.size == 0) continue;
                throw new RuntimeException("BUG! 0,1,2 are acceptable not " + this.result2.size);
            }
        }
    }

    @Override
    public FastQueue<AssociatedIndex> getMatches() {
        return this.matches;
    }

    @Override
    public GrowQueue_I32 getUnassociatedSource() {
        return this.unassociated.checkSource(this.matches, this.sizeSrc);
    }

    @Override
    public GrowQueue_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.matches, this.listDst.size());
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.maxDistance = score;
    }

    @Override
    public MatchScoreType getScoreType() {
        return MatchScoreType.NORM_ERROR;
    }

    @Override
    public boolean uniqueSource() {
        return false;
    }

    @Override
    public boolean uniqueDestination() {
        return true;
    }

    public boolean isRatioUsesSqrt() {
        return this.ratioUsesSqrt;
    }

    public void setRatioUsesSqrt(boolean ratioUsesSqrt) {
        this.ratioUsesSqrt = ratioUsesSqrt;
    }

    public double getScoreRatioThreshold() {
        return this.scoreRatioThreshold;
    }

    public void setScoreRatioThreshold(double scoreRatioThreshold) {
        this.scoreRatioThreshold = scoreRatioThreshold;
    }
}

