/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;

public abstract class NonMaxCandidate {
    int radius;
    protected float thresholdMin;
    protected float thresholdMax;
    int ignoreBorder;
    protected GrayF32 input;
    int endBorderX;
    int endBorderY;
    int x0;
    int y0;
    int x1;
    int y1;

    public void process(GrayF32 intensityImage, QueueCorner candidatesMin, QueueCorner candidatesMax, QueueCorner foundMin, QueueCorner foundMax) {
        this.input = intensityImage;
        this.endBorderX = intensityImage.width - this.ignoreBorder;
        this.endBorderY = intensityImage.height - this.ignoreBorder;
        if (candidatesMin != null) {
            this.examineMinimum(intensityImage, candidatesMin, foundMin);
        }
        if (candidatesMax != null) {
            this.examineMaximum(intensityImage, candidatesMax, foundMax);
        }
    }

    protected void examineMinimum(GrayF32 intensityImage, QueueCorner candidates, QueueCorner found) {
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        for (int iter = 0; iter < candidates.size; ++iter) {
            int center;
            float val;
            Point2D_I16 pt = ((Point2D_I16[])candidates.data)[iter];
            if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) > this.thresholdMin || val == -3.4028235E38f) continue;
            this.x0 = Math.max(0, pt.x - this.radius);
            this.y0 = Math.max(0, pt.y - this.radius);
            this.x1 = Math.min(intensityImage.width, pt.x + this.radius + 1);
            this.y1 = Math.min(intensityImage.height, pt.y + this.radius + 1);
            if (!this.searchMin(center, val)) continue;
            found.add((int)pt.x, (int)pt.y);
        }
    }

    protected void examineMaximum(GrayF32 intensityImage, QueueCorner candidates, QueueCorner found) {
        int stride = intensityImage.stride;
        float[] inten = intensityImage.data;
        for (int iter = 0; iter < candidates.size; ++iter) {
            int center;
            float val;
            Point2D_I16 pt = ((Point2D_I16[])candidates.data)[iter];
            if (pt.x < this.ignoreBorder || pt.y < this.ignoreBorder || pt.x >= this.endBorderX || pt.y >= this.endBorderY || (val = inten[center = intensityImage.startIndex + pt.y * stride + pt.x]) < this.thresholdMax || val == Float.MAX_VALUE) continue;
            this.x0 = Math.max(0, pt.x - this.radius);
            this.y0 = Math.max(0, pt.y - this.radius);
            this.x1 = Math.min(intensityImage.width, pt.x + this.radius + 1);
            this.y1 = Math.min(intensityImage.height, pt.y + this.radius + 1);
            if (!this.searchMax(center, val)) continue;
            found.add((int)pt.x, (int)pt.y);
        }
    }

    protected abstract boolean searchMin(int var1, float var2);

    protected abstract boolean searchMax(int var1, float var2);

    public void setSearchRadius(int radius) {
        this.radius = radius;
    }

    public int getSearchRadius() {
        return this.radius;
    }

    public float getThresholdMin() {
        return this.thresholdMin;
    }

    public void setThresholdMin(float thresholdMin) {
        this.thresholdMin = thresholdMin;
    }

    public float getThresholdMax() {
        return this.thresholdMax;
    }

    public void setThresholdMax(float thresholdMax) {
        this.thresholdMax = thresholdMax;
    }

    public void setBorder(int border) {
        this.ignoreBorder = border;
    }

    public int getBorder() {
        return this.ignoreBorder;
    }
}

