/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.CircularIndex;
import boofcv.numerics.InterpolateArray;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.metric.UtilAngle;
import java.util.Arrays;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class OrientationHistogramSift<Deriv extends ImageGray> {
    private double sigmaEnlarge;
    double[] histogramMag;
    double[] histogramX;
    double[] histogramY;
    private double histAngleBin;
    private GrowQueue_I32 peaks = new GrowQueue_I32(10);
    private GrowQueue_F64 angles = new GrowQueue_F64(10);
    private double peakAngle;
    private ImageRectangle bound = new ImageRectangle();
    private GImageGray derivX;
    private GImageGray derivY;
    InterpolateArray approximateGauss;
    double approximateStep = 0.1;

    public OrientationHistogramSift(int histogramSize, double sigmaEnlarge, Class<Deriv> derivType) {
        this.histogramMag = new double[histogramSize];
        this.histogramX = new double[histogramSize];
        this.histogramY = new double[histogramSize];
        this.sigmaEnlarge = sigmaEnlarge;
        this.histAngleBin = Math.PI * 2 / (double)histogramSize;
        double[] samples = new double[(int)(16.0 / this.approximateStep)];
        for (int i = 0; i < samples.length; ++i) {
            double dx2 = (double)i * this.approximateStep;
            samples[i] = Math.exp(-0.5 * dx2);
        }
        this.approximateGauss = new InterpolateArray(samples);
        this.derivX = FactoryGImageGray.create(derivType);
        this.derivY = FactoryGImageGray.create(derivType);
    }

    public void setImageGradient(Deriv derivX, Deriv derivY) {
        this.derivX.wrap(derivX);
        this.derivY.wrap(derivY);
    }

    public void process(double c_x, double c_y, double sigma) {
        int x = (int)(c_x + 0.5);
        int y = (int)(c_y + 0.5);
        this.computeHistogram(x, y, sigma);
        this.findHistogramPeaks();
    }

    void computeHistogram(int c_x, int c_y, double sigma) {
        int r = (int)Math.ceil(sigma * this.sigmaEnlarge);
        this.bound.x0 = c_x - r;
        this.bound.y0 = c_y - r;
        this.bound.x1 = c_x + r + 1;
        this.bound.y1 = c_y + r + 1;
        ImageGray rawDX = this.derivX.getImage();
        ImageGray rawDY = this.derivY.getImage();
        BoofMiscOps.boundRectangleInside((ImageBase)rawDX, (ImageRectangle)this.bound);
        Arrays.fill(this.histogramMag, 0.0);
        Arrays.fill(this.histogramX, 0.0);
        Arrays.fill(this.histogramY, 0.0);
        for (int y = this.bound.y0; y < this.bound.y1; ++y) {
            int indexDX = rawDX.startIndex + y * rawDX.stride + this.bound.x0;
            int indexDY = rawDY.startIndex + y * rawDY.stride + this.bound.x0;
            for (int x = this.bound.x0; x < this.bound.x1; ++x) {
                int h;
                float dx = this.derivX.getF(indexDX++);
                float dy = this.derivY.getF(indexDY++);
                double magnitude = Math.sqrt(dx * dx + dy * dy);
                double theta = UtilAngle.domain2PI((double)Math.atan2(dy, dx));
                double weight = this.computeWeight(x - c_x, y - c_y, sigma);
                int n = h = (int)(theta / this.histAngleBin) % this.histogramMag.length;
                this.histogramMag[n] = this.histogramMag[n] + magnitude * weight;
                int n2 = h;
                this.histogramX[n2] = this.histogramX[n2] + (double)dx * weight;
                int n3 = h;
                this.histogramY[n3] = this.histogramY[n3] + (double)dy * weight;
            }
        }
    }

    void findHistogramPeaks() {
        this.peaks.reset();
        this.angles.reset();
        this.peakAngle = 0.0;
        double largest = 0.0;
        int largestIndex = -1;
        double before = this.histogramMag[this.histogramMag.length - 2];
        double current = this.histogramMag[this.histogramMag.length - 1];
        for (int i = 0; i < this.histogramMag.length; ++i) {
            double after = this.histogramMag[i];
            if (current > before && current > after) {
                int currentIndex = CircularIndex.addOffset((int)i, (int)-1, (int)this.histogramMag.length);
                this.peaks.push(currentIndex);
                if (current > largest) {
                    largest = current;
                    largestIndex = currentIndex;
                }
            }
            before = current;
            current = after;
        }
        if (largestIndex < 0) {
            return;
        }
        double threshold = largest * 0.8;
        for (int i = 0; i < this.peaks.size; ++i) {
            int index = this.peaks.data[i];
            current = this.histogramMag[index];
            if (!(current >= threshold)) continue;
            double angle = this.computeAngle(index);
            this.angles.push(angle);
            if (index != largestIndex) continue;
            this.peakAngle = angle;
        }
    }

    double computeAngle(int index1) {
        int index0 = CircularIndex.addOffset((int)index1, (int)-1, (int)this.histogramMag.length);
        int index2 = CircularIndex.addOffset((int)index1, (int)1, (int)this.histogramMag.length);
        double v0 = this.histogramMag[index0];
        double v1 = this.histogramMag[index1];
        double v2 = this.histogramMag[index2];
        double offset = FastHessianFeatureDetector.polyPeak(v0, v1, v2);
        return this.interpolateAngle(index0, index1, index2, offset);
    }

    double interpolateAngle(int index0, int index1, int index2, double offset) {
        double deltaAngle;
        double angle1 = Math.atan2(this.histogramY[index1], this.histogramX[index1]);
        if (offset < 0.0) {
            double angle0 = Math.atan2(this.histogramY[index0], this.histogramX[index0]);
            deltaAngle = UtilAngle.dist((double)angle0, (double)angle1);
        } else {
            double angle2 = Math.atan2(this.histogramY[index2], this.histogramX[index2]);
            deltaAngle = UtilAngle.dist((double)angle2, (double)angle1);
        }
        return UtilAngle.bound((double)(angle1 + deltaAngle * offset));
    }

    double computeWeight(double deltaX, double deltaY, double sigma) {
        double d = (deltaX * deltaX + deltaY * deltaY) / (sigma * sigma) / this.approximateStep;
        if (this.approximateGauss.interpolate(d)) {
            return this.approximateGauss.value;
        }
        return 0.0;
    }

    public GrowQueue_F64 getOrientations() {
        return this.angles;
    }

    public double getPeakOrientation() {
        return this.peakAngle;
    }
}

