/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.shapes.edge.SnapToLineEdge;
import boofcv.alg.shapes.polygon.RefinePolygonToGray;
import boofcv.alg.shapes.polygon.UtilShapePolygon;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class RefinePolygonToGrayLine<T extends ImageGray<T>>
implements RefinePolygonToGray<T> {
    private double cornerOffset = 2.0;
    private int maxIterations = 10;
    private double convergeTolPixels = 0.01;
    private double maxCornerChangePixel = 2.0;
    private SnapToLineEdge<T> snapToEdge;
    private LineGeneral2D_F64[] general = new LineGeneral2D_F64[0];
    private Polygon2D_F64 previous;
    private Point2D_F64 adjA = new Point2D_F64();
    private Point2D_F64 adjB = new Point2D_F64();
    protected T image;
    private Class<T> imageType;
    private Point2D_F64 tempA = new Point2D_F64();
    private Point2D_F64 tempB = new Point2D_F64();
    private LineGeneral2D_F64 before = new LineGeneral2D_F64();

    public RefinePolygonToGrayLine(double cornerOffset, int lineSamples, int sampleRadius, int maxIterations, double convergeTolPixels, double maxCornerChangePixel, Class<T> imageType) {
        this.cornerOffset = cornerOffset;
        this.maxIterations = maxIterations;
        this.convergeTolPixels = convergeTolPixels;
        this.maxCornerChangePixel = maxCornerChangePixel;
        this.snapToEdge = new SnapToLineEdge<T>(lineSamples, sampleRadius, imageType);
        this.imageType = imageType;
        this.previous = new Polygon2D_F64(1);
    }

    public RefinePolygonToGrayLine(int numSides, Class<T> imageType) {
        this.previous = new Polygon2D_F64(numSides);
        this.imageType = imageType;
        this.snapToEdge = new SnapToLineEdge<T>(20, 1, imageType);
    }

    @Override
    public void setImage(T image) {
        this.image = image;
        this.snapToEdge.setImage(image);
    }

    @Override
    public void setLensDistortion(int width, int height, PixelTransform2_F32 distToUndist, PixelTransform2_F32 undistToDist) {
        this.snapToEdge.setTransform(undistToDist);
    }

    @Override
    public void clearLensDistortion() {
        this.snapToEdge.setTransform(null);
    }

    @Override
    public boolean refine(Polygon2D_F64 input, Polygon2D_F64 output) {
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("Input and output sides do not match. " + input.size() + " " + output.size());
        }
        if (this.checkShapeTooSmall(input)) {
            return false;
        }
        if (this.general.length < input.size()) {
            this.general = new LineGeneral2D_F64[input.size()];
            for (int i = 0; i < this.general.length; ++i) {
                this.general[i] = new LineGeneral2D_F64();
            }
        }
        return this.optimize(input, output);
    }

    private boolean checkShapeTooSmall(Polygon2D_F64 input) {
        double minLength = this.cornerOffset * 2.0 + 2.0;
        for (int i = 0; i < input.size(); ++i) {
            Point2D_F64 b;
            int j = (i + 1) % input.size();
            Point2D_F64 a = input.get(i);
            if (!(a.distance2((GeoTuple2D_F64)(b = input.get(j))) < minLength * minLength)) continue;
            return true;
        }
        return false;
    }

    protected boolean optimize(Polygon2D_F64 seed, Polygon2D_F64 current) {
        this.previous.set(seed);
        double convergeTol = this.convergeTolPixels * this.convergeTolPixels;
        for (int i = 0; i < seed.size(); ++i) {
            int j = (i + 1) % seed.size();
            Point2D_F64 a = seed.get(i);
            Point2D_F64 b = seed.get(j);
            UtilLine2D_F64.convert((Point2D_F64)a, (Point2D_F64)b, (LineGeneral2D_F64)this.general[i]);
        }
        boolean changed = false;
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            for (int i = 0; i < this.previous.size(); ++i) {
                int j = (i + 1) % this.previous.size();
                Point2D_F64 a = this.previous.get(i);
                Point2D_F64 b = this.previous.get(j);
                this.before.set(this.general[i]);
                boolean failed = false;
                if (!this.optimize(a, b, this.general[i])) {
                    failed = true;
                } else {
                    int k = (i + this.previous.size() - 1) % this.previous.size();
                    if (Intersection2D_F64.intersection((LineGeneral2D_F64)this.general[k], (LineGeneral2D_F64)this.general[i], (Point2D_F64)this.tempA) != null && Intersection2D_F64.intersection((LineGeneral2D_F64)this.general[i], (LineGeneral2D_F64)this.general[j], (Point2D_F64)this.tempB) != null) {
                        if (this.tempA.distance((GeoTuple2D_F64)a) > this.maxCornerChangePixel || this.tempB.distance((GeoTuple2D_F64)b) > this.maxCornerChangePixel) {
                            failed = true;
                        }
                    } else {
                        failed = true;
                    }
                }
                if (failed) {
                    this.general[i].set(this.before);
                    continue;
                }
                changed = true;
            }
            if (!UtilShapePolygon.convert(this.general, current)) {
                return false;
            }
            boolean converged = true;
            for (int i = 0; i < current.size(); ++i) {
                if (!(current.get(i).distance2((GeoTuple2D_F64)this.previous.get(i)) > convergeTol)) continue;
                converged = false;
                break;
            }
            if (converged) break;
            this.previous.set(current);
        }
        return changed;
    }

    protected boolean optimize(Point2D_F64 a, Point2D_F64 b, LineGeneral2D_F64 found) {
        this.computeAdjustedEndPoints(a, b);
        return this.snapToEdge.refine(this.adjA, this.adjB, found);
    }

    public void setTransform(PixelTransform2_F32 undistToDist) {
        this.snapToEdge.setTransform(undistToDist);
    }

    private void computeAdjustedEndPoints(Point2D_F64 a, Point2D_F64 b) {
        double slopeX = b.x - a.x;
        double slopeY = b.y - a.y;
        double r = Math.sqrt(slopeX * slopeX + slopeY * slopeY);
        double unitX = slopeX / r;
        double unitY = slopeY / r;
        this.adjA.x = a.x + unitX * this.cornerOffset;
        this.adjA.y = a.y + unitY * this.cornerOffset;
        this.adjB.x = b.x - unitX * this.cornerOffset;
        this.adjB.y = b.y - unitY * this.cornerOffset;
    }

    public SnapToLineEdge<T> getSnapToEdge() {
        return this.snapToEdge;
    }
}

