/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polyline.splitmerge;

import boofcv.alg.shapes.polyline.splitmerge.PolylineSplitMerge;
import boofcv.alg.shapes.polyline.splitmerge.SplitSelector;
import georegression.metric.Distance2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class MaximumLineDistance
implements SplitSelector {
    LineParametric2D_F64 line = new LineParametric2D_F64();

    @Override
    public void selectSplitPoint(List<Point2D_I32> contour, int indexA, int indexB, PolylineSplitMerge.SplitResults results) {
        PolylineSplitMerge.assignLine(contour, indexA, indexB, this.line);
        if (indexB >= indexA) {
            results.index = indexA;
            results.score = -1.0;
            for (int i = indexA + 1; i < indexB; ++i) {
                Point2D_I32 p = contour.get(i);
                double distanceSq = Distance2D_F64.distanceSq((LineParametric2D_F64)this.line, (double)p.x, (double)p.y);
                if (!(distanceSq > results.score)) continue;
                results.score = distanceSq;
                results.index = i;
            }
        } else {
            results.index = indexA;
            results.score = -1.0;
            int distance = contour.size() - indexA + indexB;
            for (int i = 1; i < distance; ++i) {
                int index = (indexA + i) % contour.size();
                Point2D_I32 p = contour.get(index);
                double distanceSq = Distance2D_F64.distanceSq((LineParametric2D_F64)this.line, (double)p.x, (double)p.y);
                if (!(distanceSq > results.score)) continue;
                results.score = distanceSq;
                results.index = index;
            }
        }
    }

    @Override
    public int compareScore(double scoreA, double scoreB) {
        if (scoreA > scoreB) {
            return 1;
        }
        if (scoreA < scoreB) {
            return -1;
        }
        return 0;
    }
}

