/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxBlock;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class NonMaxBlock_MT
extends NonMaxBlock {
    final Object lock = new Object();
    final List<NonMaxBlock.Search> searches = new ArrayList<NonMaxBlock.Search>();
    final List<QueueCorner> cornerLists = new ArrayList<QueueCorner>();

    public NonMaxBlock_MT(NonMaxBlock.Search search) {
        super(search);
    }

    @Override
    public void process(GrayF32 intensityImage, @Nullable QueueCorner localMin, @Nullable QueueCorner localMax) {
        if (localMin != null) {
            localMin.reset();
        }
        if (localMax != null) {
            localMax.reset();
        }
        int endX = intensityImage.width - this.border;
        int endY = intensityImage.height - this.border;
        int step = this.configuration.radius + 1;
        this.search.initialize(this.configuration, intensityImage, localMin, localMax);
        int range = endY - this.border;
        int N = range / step;
        if (range > N * step) {
            ++N;
        }
        BoofConcurrency.loopFor((int)0, (int)N, iterY -> {
            NonMaxBlock.Search search;
            QueueCorner threadMin = null;
            QueueCorner threadMax = null;
            Object object = this.lock;
            synchronized (object) {
                search = this.searches.isEmpty() ? this.search.newInstance() : this.searches.remove(this.searches.size() - 1);
                if (search.isDetectMinimums()) {
                    threadMin = this.pop();
                }
                if (search.isDetectMaximums()) {
                    threadMax = this.pop();
                }
            }
            search.initialize(this.configuration, intensityImage, threadMin, threadMax);
            int y = this.border + iterY * step;
            int y1 = y + step;
            if (y1 > endY) {
                y1 = endY;
            }
            for (int x = this.border; x < endX; x += step) {
                int x1 = x + step;
                if (x1 > endX) {
                    x1 = endX;
                }
                search.searchBlock(x, y, x1, y1);
            }
            Object object2 = this.lock;
            synchronized (object2) {
                this.saveResults(localMin, threadMin);
                this.saveResults(localMax, threadMax);
                this.searches.add(search);
                if (threadMin != null) {
                    this.cornerLists.add(threadMin);
                }
                if (threadMax != null) {
                    this.cornerLists.add(threadMax);
                }
            }
        });
    }

    private QueueCorner pop() {
        QueueCorner queue = this.cornerLists.isEmpty() ? new QueueCorner() : this.cornerLists.remove(this.cornerLists.size() - 1);
        queue.reset();
        return queue;
    }

    private void saveResults(QueueCorner output, QueueCorner thread) {
        if (thread != null) {
            for (int i = 0; i < thread.size; ++i) {
                ((Point2D_I16)output.grow()).set((Point2D_I16)thread.get(i));
            }
        }
    }
}

