/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.peak;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.weights.WeightPixel_F32;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;

public class MeanShiftPeak<T extends ImageGray<T>> {
    protected T image;
    protected InterpolatePixelS<T> interpolate;
    protected int maxIterations;
    protected int radius;
    protected int width;
    protected float convergenceTol;
    protected float peakX;
    protected float peakY;
    protected float x0;
    protected float y0;
    protected WeightPixel_F32 weights;

    public MeanShiftPeak(int maxIterations, float convergenceTol, WeightPixel_F32 weights, Class<T> imageType) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.weights = weights;
        this.interpolate = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)BorderType.EXTENDED);
    }

    public void setImage(T image) {
        this.image = image;
        this.interpolate.setImage(image);
    }

    public void setRadius(int radius) {
        this.weights.setRadius(radius, radius);
        this.radius = radius;
        this.width = radius * 2 + 1;
    }

    public void search(float cx, float cy) {
        this.peakX = cx;
        this.peakY = cy;
        this.setRegion(cx, cy);
        for (int i = 0; i < this.maxIterations; ++i) {
            float weight;
            float w;
            int yy;
            float total = 0.0f;
            float sumX = 0.0f;
            float sumY = 0.0f;
            int kernelIndex = 0;
            if (this.interpolate.isInFastBounds(this.x0, this.y0) && this.interpolate.isInFastBounds(this.x0 + (float)this.width - 1.0f, this.y0 + (float)this.width - 1.0f)) {
                for (yy = 0; yy < this.width; ++yy) {
                    for (int xx = 0; xx < this.width; ++xx) {
                        w = this.weights.weightIndex(kernelIndex++);
                        weight = w * this.interpolate.get_fast(this.x0 + (float)xx, this.y0 + (float)yy);
                        total += weight;
                        sumX += weight * ((float)xx + this.x0);
                        sumY += weight * ((float)yy + this.y0);
                    }
                }
            } else {
                for (yy = 0; yy < this.width; ++yy) {
                    for (int xx = 0; xx < this.width; ++xx) {
                        w = this.weights.weightIndex(kernelIndex++);
                        weight = w * this.interpolate.get(this.x0 + (float)xx, this.y0 + (float)yy);
                        total += weight;
                        sumX += weight * ((float)xx + this.x0);
                        sumY += weight * ((float)yy + this.y0);
                    }
                }
            }
            cx = sumX / total;
            cy = sumY / total;
            this.setRegion(cx, cy);
            float dx = cx - this.peakX;
            float dy = cy - this.peakY;
            this.peakX = cx;
            this.peakY = cy;
            if (Math.abs(dx) < this.convergenceTol && Math.abs(dy) < this.convergenceTol) break;
        }
    }

    protected void setRegion(float cx, float cy) {
        this.x0 = cx - (float)this.radius;
        this.y0 = cy - (float)this.radius;
        if (this.x0 < 0.0f) {
            this.x0 = 0.0f;
        } else if (this.x0 + (float)this.width > (float)((ImageGray)this.image).width) {
            this.x0 = ((ImageGray)this.image).width - this.width;
        }
        if (this.y0 < 0.0f) {
            this.y0 = 0.0f;
        } else if (this.y0 + (float)this.width > (float)((ImageGray)this.image).height) {
            this.y0 = ((ImageGray)this.image).height - this.width;
        }
    }

    public float getPeakX() {
        return this.peakX;
    }

    public float getPeakY() {
        return this.peakY;
    }
}

