/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.DisparityScoreWindowFive;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.impl.UtilDisparityScore;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class ImplDisparityScoreSadRectFive_F32<DI extends ImageGray<DI>>
extends DisparityScoreWindowFive<GrayF32, DI> {
    DisparitySelect<float[], DI> computeDisparity;
    float[] elementScore;
    float[][] horizontalScore;
    float[][] verticalScore;
    int activeVerticalScore;
    float[] fiveScore;

    public ImplDisparityScoreSadRectFive_F32(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<float[], DI> computeDisparity) {
        super(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
        this.computeDisparity = computeDisparity;
    }

    @Override
    public void _process(GrayF32 left, GrayF32 right, DI disparity) {
        if (this.horizontalScore == null || this.verticalScore.length < this.lengthHorizontal) {
            this.horizontalScore = new float[this.regionHeight][this.lengthHorizontal];
            this.verticalScore = new float[this.regionHeight][this.lengthHorizontal];
            this.elementScore = new float[left.width];
            this.fiveScore = new float[this.lengthHorizontal];
        }
        this.computeDisparity.configure(disparity, this.minDisparity, this.maxDisparity, this.radiusX * 2);
        this.computeFirstRow(left, right);
        this.computeRemainingRows(left, right);
    }

    private void computeFirstRow(GrayF32 left, GrayF32 right) {
        float[] firstRow = this.verticalScore[0];
        this.activeVerticalScore = 1;
        for (int row = 0; row < this.regionHeight; ++row) {
            float[] scores = this.horizontalScore[row];
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
        }
        for (int i = 0; i < this.lengthHorizontal; ++i) {
            float sum = 0.0f;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += this.horizontalScore[row][i];
            }
            firstRow[i] = sum;
        }
    }

    private void computeRemainingRows(GrayF32 left, GrayF32 right) {
        int row = this.regionHeight;
        while (row < left.height) {
            int i;
            int oldRow = row % this.regionHeight;
            float[] previous = this.verticalScore[(this.activeVerticalScore - 1) % this.regionHeight];
            float[] active = this.verticalScore[this.activeVerticalScore % this.regionHeight];
            float[] scores = this.horizontalScore[oldRow];
            for (i = 0; i < this.lengthHorizontal; ++i) {
                active[i] = previous[i] - scores[i];
            }
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                active[n] = active[n] + scores[i];
            }
            if (this.activeVerticalScore >= this.regionHeight - 1) {
                float[] top = this.verticalScore[(this.activeVerticalScore - 2 * this.radiusY) % this.regionHeight];
                float[] middle = this.verticalScore[(this.activeVerticalScore - this.radiusY) % this.regionHeight];
                float[] bottom = this.verticalScore[this.activeVerticalScore % this.regionHeight];
                this.computeScoreFive(top, middle, bottom, this.fiveScore, left.width);
                this.computeDisparity.process(row - (1 + 4 * this.radiusY) + 2 * this.radiusY + 1, this.fiveScore);
            }
            ++row;
            ++this.activeVerticalScore;
        }
    }

    protected void computeScoreFive(float[] top, float[] middle, float[] bottom, float[] score, int width) {
        for (int d = this.minDisparity; d < this.maxDisparity; ++d) {
            int indexSrc = (d - this.minDisparity) * width + (d - this.minDisparity) + this.radiusX;
            int indexDst = (d - this.minDisparity) * width + (d - this.minDisparity);
            int end = indexSrc + (width - d - 4 * this.radiusX);
            while (indexSrc < end) {
                float temp;
                int s = 0;
                float val0 = top[indexSrc - this.radiusX];
                float val1 = top[indexSrc + this.radiusX];
                float val2 = bottom[indexSrc - this.radiusX];
                float val3 = bottom[indexSrc + this.radiusX];
                if (val1 < val0) {
                    temp = val0;
                    val0 = val1;
                    val1 = temp;
                }
                if (val3 < val2) {
                    temp = val2;
                    val2 = val3;
                    val3 = temp;
                }
                if (val3 < val0) {
                    s = (int)((float)s + val2);
                    s = (int)((float)s + val3);
                } else if (val2 < val1) {
                    s = (int)((float)s + val2);
                    s = (int)((float)s + val0);
                } else {
                    s = (int)((float)s + val0);
                    s = (int)((float)s + val1);
                }
                score[indexDst++] = (float)s + middle[indexSrc++];
            }
        }
    }

    @Override
    public Class<GrayF32> getInputType() {
        return GrayF32.class;
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.computeDisparity.getDisparityType();
    }
}

