/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.DisparityScoreSadRect;
import boofcv.alg.feature.disparity.DisparitySelect;
import boofcv.alg.feature.disparity.impl.UtilDisparityScore;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class ImplDisparityScoreSadRect_F32<DI extends ImageGray<DI>>
extends DisparityScoreSadRect<GrayF32, DI> {
    DisparitySelect<float[], DI> computeDisparity;
    float[] elementScore;
    float[][] horizontalScore;
    float[] verticalScore;

    public ImplDisparityScoreSadRect_F32(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY, DisparitySelect<float[], DI> computeDisparity) {
        super(minDisparity, maxDisparity, regionRadiusX, regionRadiusY);
        this.computeDisparity = computeDisparity;
    }

    @Override
    public void _process(GrayF32 left, GrayF32 right, DI disparity) {
        if (this.horizontalScore == null || this.verticalScore.length < this.lengthHorizontal) {
            this.horizontalScore = new float[this.regionHeight][this.lengthHorizontal];
            this.verticalScore = new float[this.lengthHorizontal];
            this.elementScore = new float[left.width];
        }
        this.computeDisparity.configure(disparity, this.minDisparity, this.maxDisparity, this.radiusX);
        this.computeFirstRow(left, right);
        this.computeRemainingRows(left, right);
    }

    private void computeFirstRow(GrayF32 left, GrayF32 right) {
        for (int row = 0; row < this.regionHeight; ++row) {
            float[] scores = this.horizontalScore[row];
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
        }
        for (int i = 0; i < this.lengthHorizontal; ++i) {
            float sum = 0.0f;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += this.horizontalScore[row][i];
            }
            this.verticalScore[i] = sum;
        }
        this.computeDisparity.process(this.radiusY, this.verticalScore);
    }

    private void computeRemainingRows(GrayF32 left, GrayF32 right) {
        for (int row = this.regionHeight; row < left.height; ++row) {
            int i;
            int oldRow = row % this.regionHeight;
            float[] scores = this.horizontalScore[oldRow];
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                this.verticalScore[n] = this.verticalScore[n] - scores[i];
            }
            UtilDisparityScore.computeScoreRow(left, right, row, scores, this.minDisparity, this.maxDisparity, this.regionWidth, this.elementScore);
            for (i = 0; i < this.lengthHorizontal; ++i) {
                int n = i;
                this.verticalScore[n] = this.verticalScore[n] + scores[i];
            }
            this.computeDisparity.process(row - this.regionHeight + 1 + this.radiusY, this.verticalScore);
        }
    }

    @Override
    public Class<GrayF32> getInputType() {
        return GrayF32.class;
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.computeDisparity.getDisparityType();
    }
}

