/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingBasic_IL<T extends ImageInterleaved<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingBasic<T, Motion> {
    protected InterleavedF32 background;
    protected InterpolatePixelMB<T> interpolationInput;
    protected InterpolatePixelMB<InterleavedF32> interpolationBG;
    protected GImageMultiBand inputWrapper;
    protected float[] pixelInput;
    protected float[] pixelBack;

    public BackgroundMovingBasic_IL(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, ImageType<T> imageType) {
        super(learnRate, threshold, transform, imageType);
        this.interpolationInput = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, imageType);
        int numBands = imageType.getNumBands();
        this.background = new InterleavedF32(1, 1, numBands);
        this.interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, (ImageType)ImageType.il((int)numBands, InterleavedF32.class));
        this.interpolationBG.setImage((ImageBase)this.background);
        this.pixelInput = new float[numBands];
        this.pixelBack = new float[numBands];
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
    }

    public InterleavedF32 getBackground() {
        return this.background;
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill((ImageBase)this.background, (double)3.4028234663852886E38);
        this.homeToWorld.set(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        GImageMiscOps.fill((ImageBase)this.background, (double)3.4028234663852886E38);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.transform.setModel((Object)this.worldToCurrent);
        this.interpolationInput.setImage(frame);
        int numBands = frame.getNumBands();
        float minusLearn = 1.0f - this.learnRate;
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0 * numBands;
            for (int x = x0; x < x1; ++x) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)((ImageInterleaved)frame).width && this.work.y >= 0.0f && this.work.y < (float)((ImageInterleaved)frame).height) {
                    this.interpolationInput.get(this.work.x, this.work.y, this.pixelInput);
                    int band = 0;
                    while (band < numBands) {
                        float value = this.pixelInput[band];
                        float bg = this.background.data[indexBG];
                        this.background.data[indexBG] = bg == Float.MAX_VALUE ? value : minusLearn * bg + this.learnRate * value;
                        ++band;
                        ++indexBG;
                    }
                    continue;
                }
                indexBG += numBands;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands();
        float thresholdSq = (float)numBands * this.threshold * this.threshold;
        for (int y = 0; y < ((ImageInterleaved)frame).height; ++y) {
            int indexFrame = ((ImageInterleaved)frame).startIndex + y * ((ImageInterleaved)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < ((ImageInterleaved)frame).width) {
                block6: {
                    this.transform.compute((float)x, (float)y, this.work);
                    if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                        this.interpolationBG.get(this.work.x, this.work.y, this.pixelBack);
                        double sumErrorSq = 0.0;
                        for (int band = 0; band < numBands; ++band) {
                            float bg = this.pixelBack[band];
                            float pixelFrame = this.inputWrapper.getF(indexFrame + band);
                            if (bg == Float.MAX_VALUE) {
                                segmented.data[indexSegmented] = this.unknownValue;
                                break block6;
                            }
                            float diff = bg - pixelFrame;
                            sumErrorSq += (double)(diff * diff);
                        }
                        segmented.data[indexSegmented] = sumErrorSq <= (double)thresholdSq ? (byte)0 : 1;
                    } else {
                        segmented.data[indexSegmented] = this.unknownValue;
                    }
                }
                ++x;
                indexFrame += numBands;
                ++indexSegmented;
            }
        }
    }
}

